/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.framework.screens.GuiListScreen;
import org.vivecraft.client.gui.framework.widgets.SettingsList;

public abstract class GuiListEditorScreen<T>
extends GuiListScreen {
    private final Supplier<List<T>> valuesSupplier;
    private final Runnable loadDefaults;
    private final Consumer<List<T>> save;
    protected final boolean fixedEntryCount;
    protected List<T> elements;

    public GuiListEditorScreen(Component title, Screen lastScreen, boolean fixedEntryCount, Supplier<List<T>> valuesSupplier, Runnable loadDefaults, Consumer<List<T>> save) {
        super(title, lastScreen);
        this.fixedEntryCount = fixedEntryCount;
        this.valuesSupplier = valuesSupplier;
        this.loadDefaults = loadDefaults;
        this.save = save;
    }

    @Override
    protected void addLowerButtons(int top) {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155, top, 150, 20, (Component)Component.m_237115_((String)"vivecraft.gui.loaddefaults"), button -> {
            this.loadDefaults.run();
            this.elements = null;
            this.reinit = true;
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, top, 150, 20, (Component)Component.m_237115_((String)"gui.back"), button -> this.m_7379_()));
    }

    @Override
    public void m_7379_() {
        this.save.accept(this.elements);
        super.m_7379_();
    }

    protected List<T> getCurrentValues() {
        return this.list.m_6702_().stream().map(entry -> {
            if (entry instanceof ValueEntry) {
                ValueEntry valueEntry = (ValueEntry)((Object)entry);
                return valueEntry.getValue();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    protected List<SettingsList.BaseEntry> getEntries() {
        LinkedList<SettingsList.BaseEntry> entries = new LinkedList<SettingsList.BaseEntry>();
        if (this.elements == null) {
            this.elements = new ArrayList<T>((Collection)this.valuesSupplier.get());
        }
        int index = 0;
        for (T item : this.elements) {
            entries.add(this.toEntry(item, index++));
        }
        if (!this.fixedEntryCount) {
            entries.add(new SettingsList.WidgetEntry((Component)Component.m_237113_((String)""), (AbstractWidget)new Button(0, 0, 145, 20, (Component)Component.m_237115_((String)"vivecraft.options.addnew"), button -> this.addNewValue())));
        }
        return entries;
    }

    protected void addNewValue() {
        this.elements = this.getCurrentValues();
        this.reinit = true;
    }

    protected abstract ValueEntry<T> toEntry(T var1, int var2);

    protected static abstract class ValueEntry<T>
    extends SettingsList.BaseEntry {
        public ValueEntry(Component name, Supplier<String> tooltipSupplier) {
            super(name, tooltipSupplier);
        }

        public abstract T getValue();
    }
}

