/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.screenhandlers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import net.minecraft.client.Minecraft;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.CloseKeyboardContext;
import org.vivecraft.api.client.data.OpenKeyboardContext;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.gui.GuiKeyboard;
import org.vivecraft.client_vr.gui.PhysicalKeyboard;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;

public class KeyboardHandler {
    public static final Minecraft MC = Minecraft.m_91087_();
    public static final ClientDataHolderVR DH = ClientDataHolderVR.getInstance();
    public static boolean KEYBOARD_FOR_GUI;
    public static GuiKeyboard UI;
    public static RenderTarget FRAMEBUFFER;
    public static PhysicalKeyboard PHYSICAL_KEYBOARD;
    public static Vector3f POS_ROOM;
    public static Matrix4f ROTATION_ROOM;
    public static boolean SHOWING;
    private static boolean POINTED_L;
    private static boolean POINTED_R;
    private static boolean LAST_PRESSED_CLICK_L;
    private static boolean LAST_PRESSED_CLICK_R;
    private static boolean LAST_PRESSED_SHIFT;

    public static boolean showOverlay(OpenKeyboardContext context) {
        if (context == OpenKeyboardContext.FORCE || KeyboardHandler.DH.vrSettings.autoOpenKeyboard == VRSettings.AutoOpenKeyboard.ON || context == OpenKeyboardContext.FOCUS_CHAT && KeyboardHandler.DH.vrSettings.autoOpenKeyboard == VRSettings.AutoOpenKeyboard.CHAT) {
            KeyboardHandler.setOverlayShowing(true);
        }
        return SHOWING;
    }

    public static boolean hideOverlay(CloseKeyboardContext context) {
        if (context == CloseKeyboardContext.FORCE || KeyboardHandler.DH.vrSettings.autoCloseKeyboard) {
            KeyboardHandler.setOverlayShowing(false);
        }
        return SHOWING;
    }

    public static boolean setOverlayShowing(boolean showingState) {
        if (KeyboardHandler.DH.kiosk) {
            return false;
        }
        if (KeyboardHandler.DH.vrSettings.seated) {
            showingState = false;
        }
        if (showingState) {
            if (KeyboardHandler.DH.vrSettings.physicalKeyboard) {
                PHYSICAL_KEYBOARD.show();
            } else {
                UI.m_6575_(Minecraft.m_91087_(), GuiHandler.SCALED_WIDTH_MAX, GuiHandler.SCALED_HEIGHT_MAX);
            }
            SHOWING = true;
            KeyboardHandler.orientOverlay(KeyboardHandler.MC.f_91080_ != null);
            RadialHandler.setOverlayShowing(false, null);
            if (KeyboardHandler.DH.vrSettings.physicalKeyboard && KeyboardHandler.MC.f_91080_ != null) {
                GuiHandler.onScreenChanged(KeyboardHandler.MC.f_91080_, KeyboardHandler.MC.f_91080_, false);
            }
        } else {
            SHOWING = false;
            if (KeyboardHandler.DH.vrSettings.physicalKeyboard) {
                PHYSICAL_KEYBOARD.unpressAllKeys();
            }
        }
        return SHOWING;
    }

    public static void reinitKeyboard() {
        if (SHOWING) {
            if (KeyboardHandler.DH.vrSettings.physicalKeyboard) {
                PHYSICAL_KEYBOARD.show();
            } else {
                UI.m_7856_();
            }
        }
    }

    public static void processGui() {
        POINTED_L = false;
        POINTED_R = false;
        if (!SHOWING) {
            return;
        }
        if (KeyboardHandler.DH.vrSettings.seated) {
            return;
        }
        if (ROTATION_ROOM == null) {
            return;
        }
        if (KeyboardHandler.DH.vrSettings.physicalKeyboard) {
            PHYSICAL_KEYBOARD.process();
            return;
        }
        POINTED_R = UI.processCursor(POS_ROOM, ROTATION_ROOM, false);
        POINTED_L = UI.processCursor(POS_ROOM, ROTATION_ROOM, true);
    }

    public static void orientOverlay(boolean guiRelative) {
        KEYBOARD_FOR_GUI = false;
        if (!SHOWING) {
            return;
        }
        KEYBOARD_FOR_GUI = guiRelative;
        if (KeyboardHandler.DH.vrSettings.physicalKeyboard) {
            Vector3f pos = KeyboardHandler.DH.vrPlayer.vrdata_room_pre.hmd.getPositionF();
            Vector3f offset = new Vector3f(0.0f, -0.5f, 0.3f);
            offset.rotateY(-KeyboardHandler.DH.vrPlayer.vrdata_room_pre.hmd.getYawRad());
            POS_ROOM = pos.add((Vector3fc)offset);
            float yaw = (float)Math.PI - KeyboardHandler.DH.vrPlayer.vrdata_room_pre.hmd.getYawRad();
            ROTATION_ROOM.rotationY(yaw);
            ROTATION_ROOM.rotateX(2.5132742f);
        } else if (guiRelative && GuiHandler.GUI_ROTATION_ROOM != null) {
            Matrix4f guiRot = GuiHandler.GUI_ROTATION_ROOM;
            Vector3f guiUp = guiRot.transformDirection(MathUtils.UP, new Vector3f()).mul(0.8f);
            Vector3f guiFwd = guiRot.transformDirection(MathUtils.FORWARD, new Vector3f()).mul(0.25f * GuiHandler.GUI_SCALE);
            Matrix4f roomRotation = new Matrix4f();
            roomRotation.translate(GuiHandler.GUI_POS_ROOM.x - guiUp.x + guiFwd.x, GuiHandler.GUI_POS_ROOM.y - guiUp.y + guiFwd.y, GuiHandler.GUI_POS_ROOM.z - guiUp.z + guiFwd.z);
            roomRotation.mul((Matrix4fc)guiRot);
            roomRotation.rotateX(-0.5235988f);
            ROTATION_ROOM = roomRotation;
            POS_ROOM = ROTATION_ROOM.getTranslation(POS_ROOM);
            ROTATION_ROOM.setTranslation(0.0f, 0.0f, 0.0f);
        } else {
            Vector3f offset = new Vector3f(0.0f, -0.5f, -2.0f);
            Vector3f hmdPos = KeyboardHandler.DH.vrPlayer.vrdata_room_pre.hmd.getPositionF();
            Vector3f look = KeyboardHandler.DH.vrPlayer.vrdata_room_pre.hmd.getCustomVector((Vector3fc)offset).mul(0.5f);
            POS_ROOM = look.add((Vector3fc)hmdPos, new Vector3f());
            float yaw = (float)Math.PI + (float)Math.atan2(look.x, look.z);
            ROTATION_ROOM = new Matrix4f().rotationY(yaw);
        }
    }

    public static void processBindings() {
        if (!SHOWING) {
            return;
        }
        if (KeyboardHandler.DH.vrSettings.physicalKeyboard) {
            PHYSICAL_KEYBOARD.processBindings();
            return;
        }
        float uiScaleX = (float)KeyboardHandler.UI.f_96543_ / (float)GuiHandler.GUI_WIDTH;
        float uiScaleY = (float)KeyboardHandler.UI.f_96544_ / (float)GuiHandler.GUI_HEIGHT;
        int x1 = (int)((float)Math.min(Math.max((int)KeyboardHandler.UI.cursorX1, 0), GuiHandler.GUI_WIDTH) * uiScaleX);
        int y1 = (int)((float)Math.min(Math.max((int)KeyboardHandler.UI.cursorY1, 0), GuiHandler.GUI_HEIGHT) * uiScaleY);
        int x2 = (int)((float)Math.min(Math.max((int)KeyboardHandler.UI.cursorX2, 0), GuiHandler.GUI_WIDTH) * uiScaleX);
        int y2 = (int)((float)Math.min(Math.max((int)KeyboardHandler.UI.cursorY2, 0), GuiHandler.GUI_HEIGHT) * uiScaleY);
        if (POINTED_L && GuiHandler.KEY_KEYBOARD_CLICK.consumeClick(ControllerType.LEFT)) {
            UI.m_6375_(x1, y1, 0);
            LAST_PRESSED_CLICK_L = true;
        }
        if (!GuiHandler.KEY_KEYBOARD_CLICK.isDown(ControllerType.LEFT) && LAST_PRESSED_CLICK_L) {
            UI.m_6348_(x1, y1, 0);
            LAST_PRESSED_CLICK_L = false;
        }
        if (POINTED_R && GuiHandler.KEY_KEYBOARD_CLICK.consumeClick(ControllerType.RIGHT)) {
            UI.m_6375_(x2, y2, 0);
            LAST_PRESSED_CLICK_R = true;
        }
        if (!GuiHandler.KEY_KEYBOARD_CLICK.isDown(ControllerType.RIGHT) && LAST_PRESSED_CLICK_R) {
            UI.m_6348_(x2, y2, 0);
            LAST_PRESSED_CLICK_R = false;
        }
        if (GuiHandler.KEY_KEYBOARD_SHIFT.m_90859_()) {
            UI.setShift(true);
            LAST_PRESSED_SHIFT = true;
        }
        if (!GuiHandler.KEY_KEYBOARD_SHIFT.m_90857_() && LAST_PRESSED_SHIFT) {
            UI.setShift(false);
            LAST_PRESSED_SHIFT = false;
        }
    }

    public static boolean isUsingController(ControllerType type) {
        return type == ControllerType.LEFT ? POINTED_L : POINTED_R;
    }

    static {
        UI = new GuiKeyboard();
        FRAMEBUFFER = null;
        PHYSICAL_KEYBOARD = new PhysicalKeyboard();
        POS_ROOM = new Vector3f();
        ROTATION_ROOM = new Matrix4f();
        SHOWING = false;
    }
}

