/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.render.helpers.GuiHelper;
import org.vivecraft.client_vr.render.helpers.opengl.OpenGLHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mixin.client.blaze3d.RenderSystemAccessor;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class RenderHelper {
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final Minecraft MC = Minecraft.m_91087_();
    public static final ResourceLocation WHITE_TEXTURE = new ResourceLocation("vivecraft:textures/white.png");
    public static final ResourceLocation BLACK_TEXTURE = new ResourceLocation("vivecraft:textures/black.png");

    public static Matrix4f getVRModelView(RenderPass renderPass) {
        return MathUtils.toMcMat4((Matrix4fc)RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getMatrix().transpose());
    }

    public static void applyVRModelView(RenderPass renderPass, PoseStack poseStack) {
        Matrix4f modelView = RenderHelper.getVRModelView(renderPass);
        poseStack.m_85850_().m_85861_().m_27644_(modelView);
        poseStack.m_85850_().m_85864_().m_8178_(new Matrix3f(modelView));
    }

    public static void applyStereo(RenderPass renderPass, PoseStack poseStack) {
        if (renderPass == RenderPass.LEFT || renderPass == RenderPass.RIGHT) {
            Vec3 eye = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getPosition().m_82546_(RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getPosition());
            poseStack.m_85837_(-eye.f_82479_, -eye.f_82480_, -eye.f_82481_);
        }
    }

    public static Vec3 getControllerRenderPos(int c) {
        if (RenderHelper.DATA_HOLDER.vrSettings.seated && c < 2) {
            int mainHand = InteractionHand.MAIN_HAND.ordinal();
            if (RenderHelper.DATA_HOLDER.vrSettings.reverseHands) {
                c = 1 - c;
                mainHand = InteractionHand.OFF_HAND.ordinal();
            }
            if (RenderHelper.MC.f_91074_ != null && RenderHelper.MC.f_91073_ != null && TelescopeTracker.isTelescope(RenderHelper.MC.f_91074_.m_21211_()) && TelescopeTracker.isTelescope(c == mainHand ? RenderHelper.MC.f_91074_.m_21205_() : RenderHelper.MC.f_91074_.m_21206_())) {
                VRData.VRDevicePose eye = c == 0 ? RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.eye0 : RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.eye1;
                org.joml.Vector3f dir = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getDirection().mul(0.2f * RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale);
                return eye.getPosition().m_82520_((double)dir.x, (double)dir.y, (double)dir.z);
            }
            float worldScale = RenderHelper.MC.f_91074_ != null && RenderHelper.MC.f_91073_ != null ? RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale : 1.0f;
            org.joml.Vector3f dir = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getDirection();
            dir.rotateY((float)Math.PI / 180 * (c == 0 ? -35.0f : 35.0f));
            dir.y = 0.0f;
            dir.normalize();
            return RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getPosition().m_82520_((double)dir.x * 0.3 * (double)worldScale, -0.4 * (double)worldScale, (double)dir.z * 0.3 * (double)worldScale);
        }
        return RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getController(c).getPosition();
    }

    public static void setupRenderingAtController(int c, PoseStack poseStack) {
        Vec3 aimSource = RenderHelper.getControllerRenderPos(c);
        aimSource = aimSource.m_82546_(RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(RenderHelper.DATA_HOLDER.currentPass).getPosition());
        poseStack.m_85837_(aimSource.f_82479_, aimSource.f_82480_, aimSource.f_82481_);
        float sc = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale;
        if (RenderHelper.DATA_HOLDER.vrSettings.seated && RenderHelper.MC.f_91074_ != null && RenderHelper.MC.f_91073_ != null && TelescopeTracker.isTelescope(RenderHelper.MC.f_91074_.m_21211_()) && TelescopeTracker.isTelescope(c == 0 ? RenderHelper.MC.f_91074_.m_21205_() : RenderHelper.MC.f_91074_.m_21206_())) {
            poseStack.m_166854_(MathUtils.toMcMat4((Matrix4fc)RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getMatrix().invert().transpose()));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            poseStack.m_85837_((double)((c == (RenderHelper.DATA_HOLDER.vrSettings.reverseHands ? 1 : 0) ? 0.075f : -0.075f) * sc), (double)(-0.025f * sc), (double)(0.0325f * sc));
        } else {
            poseStack.m_166854_(MathUtils.toMcMat4((Matrix4fc)RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getController(c).getMatrix().invert().transpose()));
        }
        poseStack.m_85841_(sc, sc, sc);
    }

    public static void drawScreen(float partialTick, Screen screen, boolean maxGuiScale) {
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_166856_();
        poseStack.m_85837_(0.0, 0.0, -2000.0);
        RenderSystem.m_157182_();
        double guiScale = maxGuiScale ? (double)GuiHandler.GUI_SCALE_FACTOR_MAX : MC.m_91268_().m_85449_();
        int backupGuiScale = GuiHandler.GUI_SCALE_FACTOR;
        GuiHandler.GUI_SCALE_FACTOR = (int)guiScale;
        Matrix4f guiProjection = Matrix4f.m_162203_((float)0.0f, (float)((float)((double)RenderHelper.MC.m_91385_().f_83915_ / guiScale)), (float)0.0f, (float)((float)((double)RenderHelper.MC.m_91385_().f_83916_ / guiScale)), (float)1000.0f, (float)3000.0f);
        RenderSystem.m_157425_((Matrix4f)guiProjection);
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        screen.m_6305_(new PoseStack(), 0, 0, partialTick);
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GuiHandler.GUI_SCALE_FACTOR = backupGuiScale;
        poseStack.m_85849_();
        RenderSystem.m_157182_();
        if (RenderHelper.DATA_HOLDER.vrSettings.guiMipmaps) {
            OpenGLHelper.genMipmaps(RenderHelper.MC.f_91042_);
        }
    }

    public static void drawMouseMenuQuad(PoseStack poseStack, int mouseX, int mouseY) {
        RenderSystem.m_69478_();
        RenderSystem.m_69465_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        float size = 15.0f * Math.max(ClientDataHolderVR.getInstance().vrSettings.menuCrosshairScale, 1.0f / (float)MC.m_91268_().m_85449_());
        int x = (int)((float)mouseX - size * 0.5f + 1.0f);
        int y = (int)((float)mouseY - size * 0.5f + 1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)((int)size), (int)((int)size), (float)0.0f, (float)0.0f, (int)15, (int)15, (int)256, (int)256);
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
    }

    public static void drawVRConnectingMessage() {
        RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_166856_();
        poseStack.m_85837_(0.0, 0.0, -2000.0);
        RenderSystem.m_157182_();
        float guiScale = (float)MC.m_91268_().m_85449_();
        Matrix4f guiProjection = Matrix4f.m_162203_((float)0.0f, (float)((float)RenderHelper.MC.m_91385_().f_83915_ / guiScale), (float)0.0f, (float)((float)RenderHelper.MC.m_91385_().f_83916_ / guiScale), (float)1000.0f, (float)3000.0f);
        RenderSystem.m_157425_((Matrix4f)guiProjection);
        PoseStack renderStack = new PoseStack();
        int width = 200;
        List formattedChars = RenderHelper.MC.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"vivecraft.messages.connectingtoruntime"), width - 10);
        int height = formattedChars.size() * 8 + Math.max(formattedChars.size() - 1, 0) * 4 + 10;
        int x = MC.m_91268_().m_85445_() / 2 - width / 2;
        int y = MC.m_91268_().m_85446_() / 2 - height / 2;
        GuiComponent.m_93172_((PoseStack)renderStack, (int)0, (int)0, (int)MC.m_91268_().m_85445_(), (int)MC.m_91268_().m_85446_(), (int)0x40000000);
        GuiComponent.m_93172_((PoseStack)renderStack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-16777216);
        GuiHelper.renderOutline(renderStack, x, y, width, height, -1);
        for (int line = 0; line < formattedChars.size(); ++line) {
            GuiComponent.m_168749_((PoseStack)renderStack, (Font)RenderHelper.MC.f_91062_, (FormattedCharSequence)((FormattedCharSequence)formattedChars.get(line)), (int)(MC.m_91268_().m_85445_() / 2), (int)(y + 5 + line * 12), (int)-1);
        }
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static void drawSizedQuad(float displayWidth, float displayHeight, float size, float[] color, Matrix4f matrix) {
        float sizeX = size * 0.5f;
        float sizeY = sizeX * displayHeight / displayWidth;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix, -sizeX, -sizeY, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(matrix, sizeX, -sizeY, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(matrix, sizeX, sizeY, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(matrix, -sizeX, sizeY, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawSizedQuadWithLightmap(float displayWidth, float displayHeight, float size, int packedLight, Matrix4f matrix, Supplier<ShaderInstance> shader, boolean flipY) {
        RenderHelper.drawSizedQuadWithLightmap(displayWidth, displayHeight, size, packedLight, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, matrix, shader, flipY);
    }

    public static void drawSizedQuadFullbright(float displayWidth, float displayHeight, float size, float[] color, Matrix4f matrix, Supplier<ShaderInstance> shader) {
        RenderHelper.drawSizedQuadWithLightmap(displayWidth, displayHeight, size, 0xF000F0, color, matrix, shader, false);
    }

    public static void drawSizedQuadWithLightmap(float displayWidth, float displayHeight, float size, int packedLight, float[] color, Matrix4f matrix, Supplier<ShaderInstance> shader, boolean flipY) {
        float sizeX = size * 0.5f;
        float sizeY = sizeX * displayHeight / displayWidth;
        RenderSystem.m_157427_(shader);
        RenderHelper.MC.f_91063_.m_109154_().m_109896_();
        RenderHelper.MC.f_91063_.m_109155_().m_118087_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
        Vector3f light0Old = RenderSystemAccessor.getShaderLightDirections()[0];
        Vector3f light1Old = RenderSystemAccessor.getShaderLightDirections()[1];
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        normal.m_122249_(new Matrix3f(matrix));
        normal.m_122278_();
        RenderSystem.m_157450_((Vector3f)normal, (Vector3f)normal);
        RenderSystem.m_157461_((ShaderInstance)RenderSystem.m_157196_());
        bufferBuilder.m_85982_(matrix, -sizeX, -sizeY, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_7421_(0.0f, flipY ? 1.0f : 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
        bufferBuilder.m_85982_(matrix, sizeX, -sizeY, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_7421_(1.0f, flipY ? 1.0f : 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
        bufferBuilder.m_85982_(matrix, sizeX, sizeY, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_7421_(1.0f, flipY ? 0.0f : 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
        bufferBuilder.m_85982_(matrix, -sizeX, sizeY, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_7421_(0.0f, flipY ? 0.0f : 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderHelper.MC.f_91063_.m_109154_().m_109891_();
        if (light0Old != null && light1Old != null) {
            RenderSystem.m_157450_((Vector3f)light0Old, (Vector3f)light1Old);
            RenderSystem.m_157461_((ShaderInstance)RenderSystem.m_157196_());
        }
    }

    public static void renderFlatQuad(Vec3 pos, float width, float height, float yaw, int r, int g, int b, int a, PoseStack poseStack) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_166851_);
        Vec3 offset = new Vec3((double)(width * 0.5f), 0.0, (double)(height * 0.5f)).m_82524_((float)Math.PI / 180 * -yaw);
        ShadersHelper.bindTexture(WHITE_TEXTURE);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        bufferBuilder.m_85982_(matrix, (float)(pos.f_82479_ + offset.f_82479_), (float)pos.f_82480_, (float)(pos.f_82481_ + offset.f_82481_)).m_6122_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)(pos.f_82479_ + offset.f_82479_), (float)pos.f_82480_, (float)(pos.f_82481_ - offset.f_82481_)).m_6122_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)(pos.f_82479_ - offset.f_82479_), (float)pos.f_82480_, (float)(pos.f_82481_ - offset.f_82481_)).m_6122_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)(pos.f_82479_ - offset.f_82479_), (float)pos.f_82480_, (float)(pos.f_82481_ + offset.f_82481_)).m_6122_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static void renderBox(VertexConsumer consumer, Vec3 start, Vec3 end, float xSize, float ySize, Vec3i color, byte alpha, PoseStack poseStack) {
        RenderHelper.renderBox(consumer, start, end, -xSize * 0.5f, xSize * 0.5f, -ySize * 0.5f, ySize * 0.5f, color, alpha, poseStack);
    }

    public static void renderBox(VertexConsumer consumer, Vec3 start, Vec3 end, float minX, float maxX, float minY, float maxY, Vec3i color, byte alpha, PoseStack poseStack) {
        Vec3 forward = start.m_82546_(end).m_82541_();
        Vec3 right = forward.m_82537_(MathUtils.UP_D);
        right = right.m_82556_() == 0.0 ? MathUtils.LEFT_D : right.m_82541_();
        Vec3 up = right.m_82537_(forward);
        Vec3 left = right.m_82490_((double)minX);
        right = right.m_82490_((double)maxX);
        Vec3 down = up.m_82490_((double)minY);
        up = up.m_82490_((double)maxY);
        Vec3 upNormal = up.m_82541_();
        Vec3 rightNormal = right.m_82541_();
        Vec3 backRightBottom = start.m_82520_(right.f_82479_ + down.f_82479_, right.f_82480_ + down.f_82480_, right.f_82481_ + down.f_82481_);
        Vec3 backRightTop = start.m_82520_(right.f_82479_ + up.f_82479_, right.f_82480_ + up.f_82480_, right.f_82481_ + up.f_82481_);
        Vec3 backLeftBottom = start.m_82520_(left.f_82479_ + down.f_82479_, left.f_82480_ + down.f_82480_, left.f_82481_ + down.f_82481_);
        Vec3 backLeftTop = start.m_82520_(left.f_82479_ + up.f_82479_, left.f_82480_ + up.f_82480_, left.f_82481_ + up.f_82481_);
        Vec3 frontRightBottom = end.m_82520_(right.f_82479_ + down.f_82479_, right.f_82480_ + down.f_82480_, right.f_82481_ + down.f_82481_);
        Vec3 frontRightTop = end.m_82520_(right.f_82479_ + up.f_82479_, right.f_82480_ + up.f_82480_, right.f_82481_ + up.f_82481_);
        Vec3 frontLeftBottom = end.m_82520_(left.f_82479_ + down.f_82479_, left.f_82480_ + down.f_82480_, left.f_82481_ + down.f_82481_);
        Vec3 frontLeftTop = end.m_82520_(left.f_82479_ + up.f_82479_, left.f_82480_ + up.f_82480_, left.f_82481_ + up.f_82481_);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        RenderHelper.addVertex(consumer, matrix, backRightBottom, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, backLeftBottom, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, backLeftTop, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, backRightTop, color, alpha, forward);
        forward = forward.m_82548_();
        RenderHelper.addVertex(consumer, matrix, frontLeftBottom, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, frontRightBottom, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, frontRightTop, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, frontLeftTop, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, frontRightBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, backRightBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, backRightTop, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, frontRightTop, color, alpha, rightNormal);
        rightNormal = rightNormal.m_82548_();
        RenderHelper.addVertex(consumer, matrix, backLeftBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, frontLeftBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, frontLeftTop, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, backLeftTop, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, backLeftTop, color, alpha, upNormal);
        RenderHelper.addVertex(consumer, matrix, frontLeftTop, color, alpha, upNormal);
        RenderHelper.addVertex(consumer, matrix, frontRightTop, color, alpha, upNormal);
        RenderHelper.addVertex(consumer, matrix, backRightTop, color, alpha, upNormal);
        upNormal = upNormal.m_82548_();
        RenderHelper.addVertex(consumer, matrix, frontLeftBottom, color, alpha, upNormal);
        RenderHelper.addVertex(consumer, matrix, backLeftBottom, color, alpha, upNormal);
        RenderHelper.addVertex(consumer, matrix, backRightBottom, color, alpha, upNormal);
        RenderHelper.addVertex(consumer, matrix, frontRightBottom, color, alpha, upNormal);
    }

    private static void addVertex(VertexConsumer consumer, Matrix4f matrix, Vec3 pos, Vec3i color, int alpha, Vec3 normal) {
        consumer.m_85982_(matrix, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).m_6122_(color.m_123341_(), color.m_123342_(), color.m_123343_(), alpha).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    public static String checkGLError(String errorSection) {
        int error = GlStateManager.m_84118_();
        if (error != 0) {
            String errorString = switch (error) {
                case 1280 -> "invalid enum";
                case 1281 -> "invalid value";
                case 1282 -> "invalid operation";
                case 1283 -> "stack overflow";
                case 1284 -> "stack underflow";
                case 1285 -> "out of memory";
                case 1286 -> "framebuffer is not complete";
                default -> "unknown error";
            };
            VRSettings.LOGGER.error("Vivecraft: ########## GL ERROR ##########");
            VRSettings.LOGGER.error("Vivecraft: @ {}", (Object)errorSection);
            VRSettings.LOGGER.error("Vivecraft: {}: {}", (Object)error, (Object)errorString);
            return errorString;
        }
        return "";
    }
}

