/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.trackers.BowTracker;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class VRArmHelper {
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final Vec3i TP_UNLIMITED_COLOR = new Vec3i(173, 216, 230);
    private static final Vec3i TP_LIMITED_COLOR = new Vec3i(205, 169, 205);
    private static final Vec3i TP_INVALID_COLOR = new Vec3i(83, 83, 83);

    public static boolean shouldRenderHands() {
        if (VRArmHelper.DATA_HOLDER.viewOnly) {
            return false;
        }
        if (VRArmHelper.DATA_HOLDER.currentPass == RenderPass.THIRD) {
            return VRArmHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY;
        }
        return VRArmHelper.DATA_HOLDER.currentPass != RenderPass.CAMERA;
    }

    public static void renderVRHands(float partialTick, boolean renderMain, boolean renderOff, boolean menuHandMain, boolean menuHandOff, PoseStack poseStack) {
        if (!renderMain && !renderOff) {
            return;
        }
        MC.m_91307_().m_6180_("hands");
        VRArmHelper.DATA_HOLDER.isFpHand = true;
        VREffectsHelper.removeNausea(partialTick, poseStack);
        if (renderMain) {
            VRArmHelper.DATA_HOLDER.isMainHand = true;
            if (menuHandMain) {
                VRArmHelper.renderMainMenuHand(0, false, poseStack);
            } else {
                VRArmHelper.renderVRHand_Main(poseStack, partialTick);
            }
            VRArmHelper.DATA_HOLDER.isMainHand = false;
        }
        if (renderOff) {
            if (menuHandOff) {
                VRArmHelper.renderMainMenuHand(1, false, poseStack);
            } else {
                VRArmHelper.renderVRHand_Offhand(poseStack, partialTick, true);
            }
        }
        VREffectsHelper.reAddNausea(poseStack);
        VRArmHelper.DATA_HOLDER.isFpHand = false;
        MC.m_91307_().m_7238_();
    }

    public static void renderMainMenuHand(int c, boolean depthAlways, PoseStack poseStack) {
        RenderSystem.m_69482_();
        RenderSystem.m_69453_();
        poseStack.m_85836_();
        RenderHelper.setupRenderingAtController(c, poseStack);
        if (MC.m_91265_() == null) {
            ShadersHelper.bindTexture(RenderHelper.WHITE_TEXTURE);
        }
        if (depthAlways && c == 0) {
            RenderSystem.m_69456_((int)519);
        } else {
            RenderSystem.m_69456_((int)515);
        }
        Vec3i color = new Vec3i(64, 64, 64);
        byte alpha = -1;
        Vec3 start = Vec3.f_82478_;
        Vec3 end = new Vec3(0.0, 0.0, 0.18);
        if (VRArmHelper.MC.f_91073_ != null) {
            int minLight;
            float light = VRArmHelper.MC.f_91073_.m_46803_(new BlockPos(VRArmHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getPosition()));
            if (light < (float)(minLight = ShadersHelper.ShaderLight())) {
                light = minLight;
            }
            float lightPercent = light / (float)VRArmHelper.MC.f_91073_.m_7469_();
            color = new Vec3i(Mth.m_14143_((float)((float)color.m_123341_() * lightPercent)), Mth.m_14143_((float)((float)color.m_123342_() * lightPercent)), Mth.m_14143_((float)((float)color.m_123343_() * lightPercent)));
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_166851_);
        RenderHelper.renderBox((VertexConsumer)bufferBuilder, start, end, -0.02f, 0.02f, -0.0125f, 0.0125f, color, alpha, poseStack);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        poseStack.m_85849_();
        RenderSystem.m_69456_((int)515);
    }

    public static void renderVRHand_Main(PoseStack poseStack, float partialTick) {
        if ((VRArmHelper.DATA_HOLDER.climbTracker.isClimbeyClimb() || ClimbTracker.isClaws(VRArmHelper.MC.f_91074_.m_21205_())) && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.COMPLETE) {
            return;
        }
        poseStack.m_85836_();
        RenderHelper.setupRenderingAtController(0, poseStack);
        ItemStack item = VRArmHelper.MC.f_91074_.m_21205_();
        Object override = null;
        if (override != null) {
            item = override;
        }
        if (VRArmHelper.DATA_HOLDER.climbTracker.isClimbeyClimb() && !ClimbTracker.isClaws(item) && override == null) {
            item = VRArmHelper.MC.f_91074_.m_21206_();
        }
        item = VRArmHelper.getBowOverride(item, InteractionHand.MAIN_HAND);
        if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.beginEntities();
        }
        VRArmHelper.MC.f_91063_.m_109154_().m_109896_();
        MultiBufferSource.BufferSource bufferSource = MC.m_91269_().m_110104_();
        VRArmHelper.MC.f_91063_.f_109055_.m_109371_((AbstractClientPlayer)VRArmHelper.MC.f_91074_, partialTick, 0.0f, InteractionHand.MAIN_HAND, VRArmHelper.MC.f_91074_.m_21324_(partialTick), item, 0.0f, poseStack, (MultiBufferSource)bufferSource, MC.m_91290_().m_114394_((Entity)VRArmHelper.MC.f_91074_, partialTick));
        bufferSource.m_109911_();
        VRArmHelper.MC.f_91063_.m_109154_().m_109891_();
        if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.endEntities();
        }
        poseStack.m_85849_();
    }

    public static void renderVRHand_Offhand(PoseStack poseStack, float partialTick, boolean renderTeleport) {
        if (!ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf || ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.COMPLETE || !VRArmHelper.DATA_HOLDER.climbTracker.isClimbeyClimb() && !ClimbTracker.isClaws(VRArmHelper.MC.f_91074_.m_21206_())) {
            poseStack.m_85836_();
            RenderHelper.setupRenderingAtController(1, poseStack);
            ItemStack item = VRArmHelper.MC.f_91074_.m_21206_();
            Object override = null;
            if (override != null) {
                item = override;
            }
            if (VRArmHelper.DATA_HOLDER.climbTracker.isClimbeyClimb() && !ClimbTracker.isClaws(item) && override == null) {
                item = VRArmHelper.MC.f_91074_.m_21205_();
            }
            item = VRArmHelper.getBowOverride(item, InteractionHand.OFF_HAND);
            if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
                OptifineHelper.beginEntities();
            }
            VRArmHelper.MC.f_91063_.m_109154_().m_109896_();
            MultiBufferSource.BufferSource bufferSource = MC.m_91269_().m_110104_();
            VRArmHelper.MC.f_91063_.f_109055_.m_109371_((AbstractClientPlayer)VRArmHelper.MC.f_91074_, partialTick, 0.0f, InteractionHand.OFF_HAND, VRArmHelper.MC.f_91074_.m_21324_(partialTick), item, 0.0f, poseStack, (MultiBufferSource)bufferSource, MC.m_91290_().m_114394_((Entity)VRArmHelper.MC.f_91074_, partialTick));
            bufferSource.m_109911_();
            VRArmHelper.MC.f_91063_.m_109154_().m_109891_();
            if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
                OptifineHelper.endEntities();
            }
            poseStack.m_85849_();
        }
        if (renderTeleport) {
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_69472_();
            if (ClientNetworking.isLimitedSurvivalTeleport() && !VRArmHelper.DATA_HOLDER.vrPlayer.getFreeMove() && VRArmHelper.MC.f_91072_.m_105289_() && VRArmHelper.DATA_HOLDER.teleportTracker.vrMovementStyle.arcAiming && !VRArmHelper.DATA_HOLDER.bowTracker.isActive(VRArmHelper.MC.f_91074_)) {
                poseStack.m_85836_();
                RenderHelper.setupRenderingAtController(1, poseStack);
                Vec3 start = new Vec3(0.0, 0.005, 0.03);
                float max = 0.03f;
                float size = VRArmHelper.DATA_HOLDER.teleportTracker.isAiming() ? 2.0f * (VRArmHelper.DATA_HOLDER.teleportTracker.getTeleportEnergy() - 4.0f * (float)VRArmHelper.DATA_HOLDER.teleportTracker.movementTeleportDistance) / 100.0f * max : 2.0f * VRArmHelper.DATA_HOLDER.teleportTracker.getTeleportEnergy() / 100.0f * max;
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                ShadersHelper.bindTexture(RenderHelper.WHITE_TEXTURE);
                if (size > 0.0f) {
                    RenderHelper.renderFlatQuad(start.m_82520_(0.0, 0.05001, 0.0), size, size, 0.0f, TP_LIMITED_COLOR.m_123341_(), TP_LIMITED_COLOR.m_123342_(), TP_LIMITED_COLOR.m_123343_(), 128, poseStack);
                }
                RenderHelper.renderFlatQuad(start.m_82520_(0.0, 0.05, 0.0), max, max, 0.0f, TP_LIMITED_COLOR.m_123341_(), TP_LIMITED_COLOR.m_123342_(), TP_LIMITED_COLOR.m_123343_(), 50, poseStack);
                poseStack.m_85849_();
            }
            if (VRArmHelper.DATA_HOLDER.teleportTracker.isAiming()) {
                RenderSystem.m_69482_();
                if (VRArmHelper.DATA_HOLDER.teleportTracker.vrMovementStyle.arcAiming) {
                    VRArmHelper.renderTeleportArc(poseStack);
                }
            }
            RenderSystem.m_69493_();
            RenderSystem.m_69453_();
        }
    }

    private static ItemStack getBowOverride(ItemStack itemStack, InteractionHand interactionHand) {
        if (VRArmHelper.DATA_HOLDER.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow()) {
            InteractionHand interactionHand2 = interactionHand = interactionHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        }
        if (interactionHand == InteractionHand.MAIN_HAND) {
            if (BowTracker.isHoldingBow((LivingEntity)VRArmHelper.MC.f_91074_, InteractionHand.MAIN_HAND)) {
                ItemStack ammo = VRArmHelper.MC.f_91074_.m_6298_(VRArmHelper.MC.f_91074_.m_21205_());
                itemStack = ammo != ItemStack.f_41583_ && !VRArmHelper.DATA_HOLDER.bowTracker.isNotched() ? ammo : ItemStack.f_41583_;
            } else if (BowTracker.isHoldingBow((LivingEntity)VRArmHelper.MC.f_91074_, InteractionHand.OFF_HAND) && VRArmHelper.DATA_HOLDER.bowTracker.isNotched()) {
                itemStack = ItemStack.f_41583_;
            }
        } else if (BowTracker.isHoldingBow((LivingEntity)VRArmHelper.MC.f_91074_, InteractionHand.MAIN_HAND)) {
            itemStack = VRArmHelper.MC.f_91074_.m_21205_();
        }
        return itemStack;
    }

    public static void renderTeleportArc(PoseStack poseStack) {
        if (VRArmHelper.DATA_HOLDER.teleportTracker.vrMovementStyle.showBeam && VRArmHelper.DATA_HOLDER.teleportTracker.isAiming() && VRArmHelper.DATA_HOLDER.teleportTracker.movementTeleportArcSteps > 1) {
            Vec3i color;
            MC.m_91307_().m_6180_("teleportArc");
            RenderSystem.m_69481_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            ShadersHelper.bindTexture(RenderHelper.WHITE_TEXTURE);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_166851_);
            double VOffset = VRArmHelper.DATA_HOLDER.teleportTracker.lastTeleportArcDisplayOffset;
            Vec3 dest = VRArmHelper.DATA_HOLDER.teleportTracker.getDestination();
            boolean validLocation = dest.f_82479_ != 0.0 || dest.f_82480_ != 0.0 || dest.f_82481_ != 0.0;
            byte alpha = -1;
            if (!validLocation) {
                color = TP_INVALID_COLOR;
                alpha = -128;
            } else {
                color = ClientNetworking.isLimitedSurvivalTeleport() && !VRArmHelper.MC.f_91074_.m_150110_().f_35936_ ? TP_LIMITED_COLOR : TP_UNLIMITED_COLOR;
                VRArmHelper.DATA_HOLDER.teleportTracker.lastTeleportArcDisplayOffset = VOffset = (double)Util.m_137550_() * 0.001 * (double)VRArmHelper.DATA_HOLDER.teleportTracker.vrMovementStyle.textureScrollSpeed * 0.6;
            }
            float segmentHalfWidth = VRArmHelper.DATA_HOLDER.teleportTracker.vrMovementStyle.beamHalfWidth * 0.15f;
            int segments = VRArmHelper.DATA_HOLDER.teleportTracker.movementTeleportArcSteps - 1;
            if (VRArmHelper.DATA_HOLDER.teleportTracker.vrMovementStyle.beamGrow) {
                segments = (int)((double)segments * VRArmHelper.DATA_HOLDER.teleportTracker.movementTeleportProgress);
            }
            double segmentProgress = 1.0 / (double)segments;
            Vec3 cameraPosition = VRArmHelper.MC.f_91063_.m_109153_().m_90583_();
            for (int i = 0; i < segments; ++i) {
                double progress = (double)i / (double)segments + VOffset * segmentProgress;
                int progressBase = Mth.m_14107_((double)progress);
                Vec3 start = VRArmHelper.DATA_HOLDER.teleportTracker.getInterpolatedArcPosition((float)((progress -= (double)progressBase) - segmentProgress * 0.4)).m_82546_(cameraPosition);
                Vec3 end = VRArmHelper.DATA_HOLDER.teleportTracker.getInterpolatedArcPosition((float)progress).m_82546_(cameraPosition);
                float shift = (float)progress * 2.0f;
                RenderHelper.renderBox((VertexConsumer)bufferBuilder, start, end, -segmentHalfWidth, segmentHalfWidth, (-1.0f + shift) * segmentHalfWidth, (1.0f + shift) * segmentHalfWidth, color, alpha, poseStack);
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            if (validLocation && VRArmHelper.DATA_HOLDER.teleportTracker.movementTeleportProgress >= 1.0) {
                RenderSystem.m_69464_();
                Vec3 targetPos = new Vec3(dest.f_82479_, dest.f_82480_, dest.f_82481_).m_82546_(cameraPosition);
                float offset = 0.01f;
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                RenderHelper.renderFlatQuad(targetPos.m_82520_(x, y += (double)offset, z), 0.6f, 0.6f, 0.0f, (int)((double)color.m_123341_() * 1.03), (int)((double)color.m_123342_() * 1.03), (int)((double)color.m_123343_() * 1.03), 64, poseStack);
                RenderHelper.renderFlatQuad(targetPos.m_82520_(x, y += (double)offset, z), 0.4f, 0.4f, 0.0f, (int)((double)color.m_123341_() * 1.04), (int)((double)color.m_123342_() * 1.04), (int)((double)color.m_123343_() * 1.04), 64, poseStack);
                RenderHelper.renderFlatQuad(targetPos.m_82520_(x, y += (double)offset, z), 0.2f, 0.2f, 0.0f, (int)((double)color.m_123341_() * 1.05), (int)((double)color.m_123342_() * 1.05), (int)((double)color.m_123343_() * 1.05), 64, poseStack);
                RenderSystem.m_69481_();
            }
            MC.m_91307_().m_7238_();
        }
    }
}

