/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.forge;

import com.mojang.blaze3d.pipeline.RenderTarget;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.NetworkDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.vivecraft.Xplat;
import org.vivecraft.common.network.packet.c2s.VivecraftPayloadC2S;
import org.vivecraft.common.network.packet.s2c.VivecraftPayloadS2C;

public class XplatImpl
implements Xplat {
    public static boolean enableRenderTargetStencil(RenderTarget renderTarget) {
        renderTarget.enableStencil();
        return true;
    }

    public static String getUseMethodName() {
        return ObfuscationReflectionHelper.findMethod(BlockBehaviour.class, (String)"m_6227_", (Class[])new Class[]{BlockState.class, Level.class, BlockPos.class, Player.class, InteractionHand.class, BlockHitResult.class}).getName();
    }

    public static TextureAtlasSprite[] getFluidTextures(BlockAndTintGetter level, BlockPos pos, FluidState fluidStateIn) {
        return ForgeHooksClient.getFluidSprites((BlockAndTintGetter)level, (BlockPos)pos, (FluidState)fluidStateIn);
    }

    public static Biome.ClimateSettings getBiomeClimateSettings(Biome biome) {
        return biome.getModifiedClimateSettings();
    }

    public static BiomeSpecialEffects getBiomeEffects(Biome biome) {
        return biome.getModifiedSpecialEffects();
    }

    public static double getItemEntityReach(double baseRange, ItemStack itemStack, EquipmentSlot slot) {
        Collection attributes = itemStack.m_41638_(slot).get((Object)((Attribute)ForgeMod.ATTACK_RANGE.get()));
        for (AttributeModifier a : attributes) {
            if (a.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
            baseRange += a.m_22218_();
        }
        double totalRange = baseRange;
        for (AttributeModifier a : attributes) {
            if (a.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
            totalRange += baseRange * a.m_22218_();
        }
        for (AttributeModifier a : attributes) {
            if (a.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            totalRange *= 1.0 + a.m_22218_();
        }
        return totalRange;
    }

    public static Packet<?> getC2SPacket(VivecraftPayloadC2S payload) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        payload.write(buffer);
        return NetworkDirection.PLAY_TO_SERVER.buildPacket((Pair)new ImmutablePair((Object)buffer, (Object)0), payload.id()).getThis();
    }

    public static Packet<?> getS2CPacket(VivecraftPayloadS2C payload) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        payload.write(buffer);
        return NetworkDirection.PLAY_TO_CLIENT.buildPacket((Pair)new ImmutablePair((Object)buffer, (Object)0), payload.id()).getThis();
    }

    public static boolean hasKeyModifier(KeyMapping keyMapping) {
        return keyMapping.getKeyModifier() != KeyModifier.NONE;
    }

    public static int getKeyModifier(KeyMapping keyMapping) {
        return switch (keyMapping.getKeyModifier()) {
            case KeyModifier.SHIFT -> 1;
            case KeyModifier.ALT -> 4;
            case KeyModifier.CONTROL -> 2;
            default -> 0;
        };
    }

    public static int getKeyModifierKey(KeyMapping keyMapping) {
        return switch (keyMapping.getKeyModifier()) {
            case KeyModifier.SHIFT -> 340;
            case KeyModifier.ALT -> 346;
            case KeyModifier.CONTROL -> 341;
            default -> -1;
        };
    }

    public static boolean isFakePlayer(ServerPlayer player) {
        return player instanceof FakePlayer;
    }
}

