/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.world.item.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShapedRecipe.class})
public abstract class ShapedRecipeMixin {
    @Inject(method={"itemFromJson"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/DefaultedRegistry;getOptional(Lnet/minecraft/resources/ResourceLocation;)Ljava/util/Optional;")}, cancellable=true)
    private static void vivecraft$getVivecraftVanillaItemInject(JsonObject jsonObject, CallbackInfoReturnable<Item> cir, @Local String resourceLocation) {
        if (resourceLocation.startsWith("vivecraft")) {
            cir.setReturnValue((Object)ShapedRecipeMixin.vivecraft$getVivecraftVanillaItem(jsonObject));
        }
    }

    @Unique
    private static Item vivecraft$getVivecraftVanillaItem(JsonObject jsonObject) {
        String vanillaItem = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"vanillaitem");
        return (Item)Registry.f_122827_.m_6612_(new ResourceLocation(vanillaItem)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + vanillaItem + "'"));
    }

    @Inject(method={"itemStackFromJson"}, at={@At(value="HEAD")}, cancellable=true)
    private static void vivecraft$customizeVanillaItemStackFabric(JsonObject jsonObject, CallbackInfoReturnable<ItemStack> cir) {
        if (GsonHelper.m_13906_((JsonObject)jsonObject, (String)"item").startsWith("vivecraft")) {
            Item vanillaItem = ShapedRecipeMixin.vivecraft$getVivecraftVanillaItem(jsonObject);
            cir.setReturnValue((Object)ShapedRecipeMixin.vivecraft$customizeVanillaItemStack(jsonObject, vanillaItem));
        }
    }

    @Unique
    private static ItemStack vivecraft$customizeVanillaItemStack(JsonObject jsonObject, Item vanillaItem) {
        if (jsonObject.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"count", (int)1);
        if (i < 1) {
            throw new JsonSyntaxException("Invalid output count: " + i);
        }
        ItemStack itemStack = new ItemStack((ItemLike)vanillaItem, i);
        if (jsonObject.has("fallbackname")) {
            itemStack.m_41714_((Component)Component.m_237115_((String)jsonObject.get("name").getAsString()));
        } else {
            itemStack.m_41714_((Component)Component.m_237115_((String)jsonObject.get("name").getAsString()));
        }
        itemStack.m_41784_().m_128379_("Unbreakable", GsonHelper.m_13855_((JsonObject)jsonObject, (String)"unbreakable", (boolean)false));
        itemStack.m_41784_().m_128405_("HideFlags", GsonHelper.m_13824_((JsonObject)jsonObject, (String)"hideflags", (int)0));
        if (jsonObject.has("color")) {
            itemStack.m_41698_("display").m_128405_("color", GsonHelper.m_13824_((JsonObject)jsonObject, (String)"color", (int)0));
        }
        return itemStack;
    }
}

