/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.common.api_impl.VRAPIImpl;
import org.vivecraft.common.network.CommonNetworkHelper;
import org.vivecraft.common.network.NetworkVersion;
import org.vivecraft.common.network.VrPlayerState;
import org.vivecraft.common.utils.MathUtils;

public class ServerVivePlayer {
    @Nullable
    private VrPlayerState vrPlayerState;
    private VRPose vrPlayerStateAsPose;
    public float draw;
    public float worldScale = 1.0f;
    public float heightScale = 1.0f;
    public VRBodyPart activeBodyPart = VRBodyPart.MAIN_HAND;
    public ItemStack activeItemOverride = ItemStack.f_41583_;
    public VRBodyPart delayedDestroyBodyPart = null;
    public boolean useBodyPartForAim = false;
    public boolean crawling;
    private boolean isVR = false;
    public Vec3 offset = Vec3.f_82478_;
    public ServerPlayer player;
    public NetworkVersion networkVersion = NetworkVersion.fromProtocolVersion(CommonNetworkHelper.MAX_SUPPORTED_NETWORK_PROTOCOL);
    public boolean wantsDamageDirection = false;

    public ServerVivePlayer(ServerPlayer player) {
        this.player = player;
    }

    public Vec3 getBodyPartVectorCustom(VRBodyPart bodyPart, Vector3fc direction) {
        if (this.vrPlayerState != null) {
            if (this.isSeated() || !bodyPart.availableInMode(this.vrPlayerState.fbtMode())) {
                bodyPart = VRBodyPart.MAIN_HAND;
            }
            return MathUtils.toMcVec3((Vector3fc)this.vrPlayerState.getBodyPartPose(bodyPart).orientation().transform(direction, new Vector3f()));
        }
        return this.player.m_20154_();
    }

    public Vec3 getBodyPartDir(VRBodyPart bodyPart) {
        return this.getBodyPartVectorCustom(bodyPart, MathUtils.BACK);
    }

    public Vec3 getAimDir(boolean ignoreUseForAim) {
        if (!this.isSeated() && this.draw > 0.0f) {
            return this.getBodyPartPos(this.activeBodyPart.opposite()).m_82546_(this.getBodyPartPos(this.activeBodyPart)).m_82541_();
        }
        if (ignoreUseForAim || this.useBodyPartForAim) {
            return this.getBodyPartDir(this.activeBodyPart);
        }
        return this.getBodyPartDir(VRBodyPart.MAIN_HAND);
    }

    public Vec3 getAimPos(boolean ignoreUseForAim) {
        if (ignoreUseForAim || this.useBodyPartForAim) {
            return this.getBodyPartPos(this.activeBodyPart);
        }
        return this.getBodyPartPos(VRBodyPart.MAIN_HAND);
    }

    public Vec3 getHMDDir() {
        if (this.vrPlayerState != null) {
            return MathUtils.toMcVec3((Vector3fc)this.vrPlayerState.hmd().orientation().transform(MathUtils.BACK, new Vector3f()));
        }
        return this.player.m_20154_();
    }

    public Vec3 getHMDPos() {
        if (this.vrPlayerState != null) {
            Vector3fc hmdPos = this.vrPlayerState.hmd().position();
            return this.player.m_20182_().m_82520_(this.offset.f_82479_ + (double)hmdPos.x(), this.offset.f_82480_ + (double)hmdPos.y(), this.offset.f_82481_ + (double)hmdPos.z());
        }
        return this.player.m_20182_().m_82520_(0.0, 1.62, 0.0);
    }

    public Vec3 getBodyPartPos(VRBodyPart bodyPart, boolean realPosition) {
        if (this.vrPlayerState != null) {
            if (!bodyPart.availableInMode(this.vrPlayerState.fbtMode())) {
                bodyPart = VRBodyPart.MAIN_HAND;
            }
            if (this.isSeated() && bodyPart.isHand() && !realPosition) {
                Vec3 dir = this.getHMDDir();
                dir = dir.m_82524_((float)Math.PI / 180 * (bodyPart == VRBodyPart.MAIN_HAND ? -35.0f : 35.0f));
                dir = new Vec3(dir.f_82479_, 0.0, dir.f_82481_);
                dir = dir.m_82541_();
                return this.getHMDPos().m_82520_(dir.f_82479_ * (double)0.3f * (double)this.worldScale, (double)(-0.4f * this.worldScale), dir.f_82481_ * (double)0.3f * (double)this.worldScale);
            }
            Vector3fc conPos = this.vrPlayerState.getBodyPartPose(bodyPart).position();
            return this.player.m_20182_().m_82520_(this.offset.f_82479_ + (double)conPos.x(), this.offset.f_82480_ + (double)conPos.y(), this.offset.f_82481_ + (double)conPos.z());
        }
        return this.player.m_20182_().m_82520_(0.0, 1.62, 0.0);
    }

    public Vec3 getBodyPartPos(VRBodyPart bodyPart) {
        return this.getBodyPartPos(bodyPart, false);
    }

    public boolean isVR() {
        return this.isVR;
    }

    public void setVR(boolean vr) {
        this.isVR = vr;
    }

    public boolean isSeated() {
        return this.vrPlayerState != null && this.vrPlayerState.seated();
    }

    public boolean isLeftHanded() {
        return this.vrPlayerState != null && this.vrPlayerState.leftHanded();
    }

    @Nullable
    public VrPlayerState vrPlayerState() {
        return this.vrPlayerState;
    }

    public void setVrPlayerState(VrPlayerState vrPlayerState) {
        this.vrPlayerState = vrPlayerState;
        this.vrPlayerStateAsPose = null;
        VRAPIImpl.INSTANCE.addPoseToHistory(this.player.m_20148_(), vrPlayerState.asVRPose(this.player.m_20182_()), this.player.m_20182_(), false);
    }

    public VRPose asVRPose() {
        if (this.vrPlayerState == null) {
            return null;
        }
        if (this.vrPlayerStateAsPose == null) {
            this.vrPlayerStateAsPose = this.vrPlayerState.asVRPose(this.player.m_20182_());
        }
        return this.vrPlayerStateAsPose;
    }
}

