/*
 * Decompiled with CFR 0.152.
 */
package com.leafuke.minebackup;

import com.leafuke.minebackup.Command;
import com.leafuke.minebackup.knotlink.SignalSubscriber;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MineBackup
implements ModInitializer {
    public static final String MOD_ID = "minebackup";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"minebackup");
    private static SignalSubscriber knotLinkSubscriber;
    private static volatile MinecraftServer serverInstance;
    public static final String BROADCAST_APP_ID = "0x00000020";
    public static final String BROADCAST_SIGNAL_ID = "0x00000020";

    public void onInitialize() {
        LOGGER.info("Initializing MineBackup for Fabric...");
        this.registerServerLifecycleEvents();
        this.registerCommands();
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> Command.register((CommandDispatcher<class_2168>)dispatcher));
    }

    private void registerServerLifecycleEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            LOGGER.info("MineBackup Mod: Server is starting, initializing KnotLink Subscriber...");
            serverInstance = server;
            knotLinkSubscriber = new SignalSubscriber("0x00000020", "0x00000020");
            knotLinkSubscriber.setSignalListener(this::handleBroadcastEvent);
            new Thread(knotLinkSubscriber::start).start();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            LOGGER.info("MineBackup Mod: Server is stopping, shutting down KnotLink Subscriber...");
            if (knotLinkSubscriber != null) {
                knotLinkSubscriber.stop();
            }
            serverInstance = null;
        });
    }

    private Map<String, String> parsePayload(String payload) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (payload == null || payload.isEmpty()) {
            return dataMap;
        }
        for (String pair : payload.split(";")) {
            String[] keyValue = pair.split("=", 2);
            if (keyValue.length != 2) continue;
            dataMap.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return dataMap;
    }

    private void handleBroadcastEvent(String payload) {
        class_5250 message;
        if (serverInstance == null) {
            return;
        }
        if ("minebackup save".equals(payload)) {
            serverInstance.execute(() -> {
                LOGGER.info("Received 'minebackup save' command, executing immediate world save.");
                serverInstance.method_3760().method_43514((class_2561)class_2561.method_43471((String)"minebackup.message.remote_save.start"), false);
                boolean allLevelsSaved = serverInstance.method_3723(true, true, true);
                if (allLevelsSaved) {
                    serverInstance.method_3760().method_43514((class_2561)class_2561.method_43471((String)"minebackup.message.remote_save.success"), false);
                } else {
                    serverInstance.method_3760().method_43514((class_2561)class_2561.method_43471((String)"minebackup.message.remote_save.fail"), false);
                }
            });
            return;
        }
        LOGGER.info("Received MineBackup broadcast event: {}", (Object)payload);
        Map<String, String> eventData = this.parsePayload(payload);
        String eventType = eventData.get("event");
        if (eventType == null) {
            return;
        }
        switch (eventType) {
            case "backup_started": {
                class_5250 class_52502 = class_2561.method_43469((String)"minebackup.broadcast.backup.started", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "restore_started": {
                class_5250 class_52502 = class_2561.method_43469((String)"minebackup.broadcast.restore.started", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "backup_success": {
                class_5250 class_52502 = class_2561.method_43469((String)"minebackup.broadcast.backup.success", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World"), eventData.getOrDefault("file", "\u672a\u77e5\u6587\u4ef6")});
                break;
            }
            case "backup_failed": {
                class_5250 class_52502 = class_2561.method_43469((String)"minebackup.broadcast.backup.failed", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World"), eventData.getOrDefault("error", "\u672a\u77e5\u9519\u8bef")});
                break;
            }
            case "game_session_end": {
                class_5250 class_52502 = class_2561.method_43469((String)"minebackup.broadcast.session.end", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "auto_backup_started": {
                class_5250 class_52502 = class_2561.method_43469((String)"minebackup.broadcast.auto_backup.started", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            default: {
                class_5250 class_52502 = message = null;
            }
        }
        if ("pre_hot_backup".equals(eventType)) {
            serverInstance.execute(() -> {
                LOGGER.info("Executing immediate save for pre_hot_backup event.");
                String worldName = eventData.getOrDefault("world", "Unknown World");
                serverInstance.method_3760().method_43514((class_2561)class_2561.method_43469((String)"minebackup.broadcast.hot_backup.request", (Object[])new Object[]{worldName}), false);
                boolean allSaved = serverInstance.method_3723(true, true, true);
                if (!allSaved) {
                    LOGGER.warn("One or more levels failed to save during pre_hot_backup for world: {}", (Object)worldName);
                    serverInstance.method_3760().method_43514((class_2561)class_2561.method_43469((String)"minebackup.broadcast.hot_backup.warn", (Object[])new Object[]{worldName}), false);
                }
                LOGGER.info("World saved successfully for hot backup.");
                serverInstance.method_3760().method_43514((class_2561)class_2561.method_43471((String)"minebackup.broadcast.hot_backup.complete"), false);
            });
        } else if ("game_session_start".equals(eventType)) {
            LOGGER.info("MineBackup detected game session start for world: {}", (Object)eventData.getOrDefault("world", "Unknown World"));
        }
        if (message != null) {
            serverInstance.execute(() -> MineBackup.lambda$handleBroadcastEvent$5((class_2561)message));
        }
    }

    private static /* synthetic */ void lambda$handleBroadcastEvent$5(class_2561 message) {
        serverInstance.method_3760().method_43514(message, false);
    }
}

