/*
 * Decompiled with CFR 0.152.
 */
package com.leafuke.minebackup;

import com.leafuke.minebackup.Command;
import com.leafuke.minebackup.MineBackupClient;
import com.leafuke.minebackup.knotlink.OpenSocketQuerier;
import com.leafuke.minebackup.knotlink.SignalSender;
import com.leafuke.minebackup.knotlink.SignalSubscriber;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="minebackup")
public class MineBackup {
    public static final String MOD_ID = "minebackup";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"minebackup");
    private static SignalSubscriber knotLinkSubscriber = null;
    private static volatile MinecraftServer serverInstance;
    public static final String BROADCAST_APP_ID = "0x00000020";
    public static final String BROADCAST_SIGNAL_ID = "0x00000020";
    private static final String QUERIER_APP_ID = "0x00000020";
    private static final String QUERIER_SOCKET_ID = "0x00000010";

    public MineBackup(IEventBus modEventBus, Dist dist) {
        LOGGER.info("Initializing MineBackup for NeoForge...");
        NeoForge.EVENT_BUS.register((Object)this);
        if (dist.isClient()) {
            MineBackupClient.initialize();
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        Command.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        if (knotLinkSubscriber == null) {
            LOGGER.info("MineBackup Mod: Server is starting, initializing KnotLink Subscriber...");
            serverInstance = event.getServer();
            knotLinkSubscriber = new SignalSubscriber("0x00000020", "0x00000020");
            knotLinkSubscriber.setSignalListener(this::handleBroadcastEvent);
            new Thread(knotLinkSubscriber::start).start();
        }
    }

    private Map<String, String> parsePayload(String payload) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (payload == null || payload.isEmpty()) {
            return dataMap;
        }
        for (String pair : payload.split(";")) {
            String[] keyValue = pair.split("=", 2);
            if (keyValue.length != 2) continue;
            dataMap.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return dataMap;
    }

    private static void BroadcastEvent(String event) {
        SignalSender sender = new SignalSender("0x00000020", "0x00000020");
        sender.emitt(event);
    }

    private void handleBroadcastEvent(String payload) {
        MutableComponent message;
        if (serverInstance == null) {
            return;
        }
        if ("minebackup save".equals(payload)) {
            serverInstance.execute(() -> {
                LOGGER.info("Received 'minebackup save' command, executing immediate world save.");
                serverInstance.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"minebackup.message.remote_save.start"), false);
                boolean allLevelsSaved = serverInstance.saveAllChunks(true, true, true);
                if (allLevelsSaved) {
                    serverInstance.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"minebackup.message.remote_save.success"), false);
                } else {
                    serverInstance.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"minebackup.message.remote_save.fail"), false);
                }
            });
            return;
        }
        LOGGER.info("Received MineBackup broadcast event: {}", (Object)payload);
        Map<String, String> eventData = this.parsePayload(payload);
        String eventType = eventData.get("event");
        if (eventType == null) {
            return;
        }
        if ("pre_hot_restore".equals(eventType)) {
            LOGGER.info("Received 'pre_hot_restore'. Preparing for hot restore.");
            serverInstance.execute(() -> {
                serverInstance.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"minebackup.message.restore.preparing"), false);
                if (serverInstance.isDedicatedServer()) {
                    LOGGER.info("Dedicated server detected. Kicking all players and stopping.");
                    List playerList = serverInstance.getPlayerList().getPlayers();
                    MutableComponent kickMessage = Component.translatable((String)"minebackup.message.restore.kick");
                    for (ServerPlayer player : playerList) {
                        player.connection.disconnect((Component)kickMessage);
                    }
                    OpenSocketQuerier.query("0x00000020", QUERIER_SOCKET_ID, "SHUTDOWN_WORLD_SUCCESS");
                    serverInstance.stopServer();
                } else {
                    String levelId;
                    LOGGER.info("Single-player instance detected. Saving and disconnecting player.");
                    MineBackupClient.worldToRejoin = levelId = serverInstance.getWorldData().getLevelName();
                    serverInstance.saveAllChunks(true, false, true);
                    ServerPlayer singlePlayer = (ServerPlayer)serverInstance.getPlayerList().getPlayers().get(0);
                    MutableComponent kickMessage = Component.translatable((String)"minebackup.message.restore.kick");
                    singlePlayer.connection.disconnect((Component)kickMessage);
                    OpenSocketQuerier.query("0x00000020", QUERIER_SOCKET_ID, "SHUTDOWN_WORLD_SUCCESS");
                }
            });
            return;
        }
        if ("restore_finished".equals(eventType)) {
            MineBackupClient.readyToRejoin = true;
            LOGGER.info("Restore successful. Flagging client to rejoin world.");
            return;
        }
        String levelId = serverInstance.getWorldData().getLevelName();
        switch (eventType) {
            case "backup_started": {
                MutableComponent mutableComponent = Component.translatable((String)"minebackup.broadcast.backup.started", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "restore_started": {
                MutableComponent mutableComponent = Component.translatable((String)"minebackup.broadcast.restore.started", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "backup_success": {
                MutableComponent mutableComponent = Component.translatable((String)"minebackup.broadcast.backup.success", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World"), eventData.getOrDefault("file", "\u672a\u77e5\u6587\u4ef6")});
                break;
            }
            case "backup_failed": {
                MutableComponent mutableComponent = Component.translatable((String)"minebackup.broadcast.backup.failed", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World"), eventData.getOrDefault("error", "\u672a\u77e5\u9519\u8bef")});
                break;
            }
            case "game_session_end": {
                MutableComponent mutableComponent = Component.translatable((String)"minebackup.broadcast.session.end", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "auto_backup_started": {
                MutableComponent mutableComponent = Component.translatable((String)"minebackup.broadcast.auto_backup.started", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "we_snapshot_completed": {
                MutableComponent mutableComponent = Component.translatable((String)"minebackup.broadcast.we_snapshot.completed", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World"), eventData.getOrDefault("file", "\u672a\u77e5\u6587\u4ef6")});
                break;
            }
            default: {
                MutableComponent mutableComponent = message = null;
            }
        }
        if ("pre_hot_backup".equals(eventType)) {
            serverInstance.execute(() -> {
                LOGGER.info("Executing immediate save for pre_hot_backup event.");
                String worldName = levelId;
                serverInstance.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"minebackup.broadcast.hot_backup.request", (Object[])new Object[]{worldName}), false);
                boolean allSaved = serverInstance.saveAllChunks(true, true, true);
                if (!allSaved) {
                    LOGGER.warn("One or more levels failed to save during pre_hot_backup for world: {}", (Object)worldName);
                    serverInstance.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"minebackup.broadcast.hot_backup.warn", (Object[])new Object[]{worldName}), false);
                }
                LOGGER.info("World saved successfully for hot backup.");
                serverInstance.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"minebackup.broadcast.hot_backup.complete"), false);
            });
        } else if ("game_session_start".equals(eventType)) {
            LOGGER.info("MineBackup detected game session start for world: {}", (Object)levelId);
        }
        if (message != null) {
            serverInstance.execute(() -> MineBackup.lambda$handleBroadcastEvent$3((Component)message));
        }
    }

    private static /* synthetic */ void lambda$handleBroadcastEvent$3(Component message) {
        serverInstance.getPlayerList().broadcastSystemMessage(message, false);
    }
}

