/*
 * Decompiled with CFR 0.152.
 */
package com.leafuke.minebackup.knotlink;

import com.leafuke.minebackup.knotlink.TcpClient;
import com.mojang.logging.LogUtils;
import org.slf4j.Logger;

public class SignalSubscriber {
    private static final Logger LOGGER = LogUtils.getLogger();
    private TcpClient KLsubscriber;
    private final String appID;
    private final String signalID;
    private SignalListener signalListener;

    public SignalSubscriber(String appID, String signalID) {
        this.appID = appID;
        this.signalID = signalID;
    }

    public void setSignalListener(SignalListener listener) {
        this.signalListener = listener;
    }

    public void start() {
        this.KLsubscriber = new TcpClient();
        if (this.KLsubscriber.connectToServer("127.0.0.1", 6372)) {
            this.KLsubscriber.setDataReceivedListener(data -> {
                System.out.println("DEBUG: Raw data received from KnotLink: " + data);
                this.signalListener.onSignalReceived(data);
            });
            String s_key = this.appID + "-" + this.signalID;
            this.KLsubscriber.sendData(s_key);
            LOGGER.info("SignalSubscriber started and subscribed to {}.", (Object)s_key);
        } else {
            LOGGER.error("SignalSubscriber failed to start.");
        }
    }

    public void stop() {
        if (this.KLsubscriber != null) {
            this.KLsubscriber.close();
            LOGGER.info("SignalSubscriber stopped.");
        }
    }

    public static interface SignalListener {
        public void onSignalReceived(String var1);
    }
}

