/*
 * Decompiled with CFR 0.152.
 */
package com.leafuke.minebackup;

import com.leafuke.minebackup.knotlink.OpenSocketQuerier;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class Command {
    private static final String QUERIER_APP_ID = "0x00000020";
    private static final String QUERIER_SOCKET_ID = "0x00000010";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"minebackup").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"save").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            MinecraftServer server = source.method_9211();
            source.method_9226((class_2561)new class_2588("minebackup.message.save.start"), true);
            for (class_3218 level : server.method_3738()) {
                level.method_14176(null, true, false);
            }
            source.method_9226((class_2561)new class_2588("minebackup.message.save.success"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"list_configs").executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("minebackup.message.list_configs.start"), false);
            Command.queryBackend("LIST_CONFIGS", response -> Command.handleListConfigsResponse((class_2168)ctx.getSource(), response));
            return 1;
        }))).then(class_2170.method_9247((String)"list_worlds").then(class_2170.method_9244((String)"config_id", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            int configId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id");
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("minebackup.message.list_worlds.start", new Object[]{String.valueOf(configId)}), false);
            Command.queryBackend(String.format("LIST_WORLDS %d", configId), response -> Command.handleListWorldsResponse((class_2168)ctx.getSource(), response, configId));
            return 1;
        })))).then(class_2170.method_9247((String)"list_backups").then(class_2170.method_9244((String)"config_id", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"world_index", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            int configId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id");
            int worldIndex = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index");
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("minebackup.message.list_backups.start", new Object[]{String.valueOf(configId), String.valueOf(worldIndex)}), false);
            Command.queryBackend(String.format("LIST_BACKUPS %d %d", configId, worldIndex), response -> Command.handleListBackupsResponse((class_2168)ctx.getSource(), response, configId, worldIndex));
            return 1;
        }))))).then(class_2170.method_9247((String)"backup").then(class_2170.method_9244((String)"config_id", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"world_index", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> Command.executeRemoteCommand((class_2168)ctx.getSource(), String.format("BACKUP %d %d", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index"))))).then(class_2170.method_9244((String)"comment", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> Command.executeRemoteCommand((class_2168)ctx.getSource(), String.format("BACKUP %d %d %s", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index"), StringArgumentType.getString((CommandContext)ctx, (String)"comment"))))))))).then(class_2170.method_9247((String)"restore").then(class_2170.method_9244((String)"config_id", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"world_index", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"backup_file", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> Command.suggestBackupFiles(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index"), builder)).executes(ctx -> Command.executeRemoteCommand((class_2168)ctx.getSource(), String.format("RESTORE %d %d %s", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index"), StringArgumentType.getString((CommandContext)ctx, (String)"backup_file"))))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"quicksave").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            MinecraftServer server = source.method_9211();
            source.method_9226((class_2561)new class_2588("minebackup.message.save.start"), true);
            for (class_3218 level : server.method_3738()) {
                level.method_14176(null, true, false);
            }
            source.method_9226((class_2561)new class_2588("minebackup.message.save.success"), true);
            Command.executeRemoteCommand(source, "BACKUP_CURRENT");
            return 1;
        })).then(class_2170.method_9244((String)"comment", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            MinecraftServer server = source.method_9211();
            source.method_9226((class_2561)new class_2588("minebackup.message.save.start"), true);
            for (class_3218 level : server.method_3738()) {
                level.method_14176(null, true, false);
            }
            source.method_9226((class_2561)new class_2588("minebackup.message.save.success"), true);
            Command.executeRemoteCommand(source, String.format("BACKUP_CURRENT %s", StringArgumentType.getString((CommandContext)ctx, (String)"comment")));
            return 1;
        })))).then(class_2170.method_9247((String)"auto").then(class_2170.method_9244((String)"config_id", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"world_index", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"internal_time", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> Command.executeRemoteCommand((class_2168)ctx.getSource(), String.format("AUTO_BACKUP %d %d %d", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"internal_time"))))))))).then(class_2170.method_9247((String)"stop").then(class_2170.method_9244((String)"config_id", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"world_index", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> Command.executeRemoteCommand((class_2168)ctx.getSource(), String.format("STOP_AUTO_BACKUP %d %d", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index"))))))));
    }

    private static void queryBackend(String command, Consumer<String> callback) {
        OpenSocketQuerier.query(QUERIER_APP_ID, QUERIER_SOCKET_ID, command).thenAccept((Consumer)callback);
    }

    private static int executeRemoteCommand(class_2168 source, String command) {
        source.method_9226((class_2561)new class_2588("minebackup.message.command.sent", new Object[]{command}), false);
        Command.queryBackend(command, response -> source.method_9211().execute(() -> {
            if (response != null && response.startsWith("ERROR:")) {
                source.method_9213((class_2561)new class_2588("minebackup.message.command.fail", new Object[]{response.substring(6)}));
            } else {
                source.method_9226((class_2561)new class_2588("minebackup.message.command.response", new Object[]{response}), false);
            }
        }));
        return 1;
    }

    private static void handleListConfigsResponse(class_2168 source, String response) {
        source.method_9211().execute(() -> {
            if (response == null || !response.startsWith("OK:")) {
                String error = response != null ? response : "No response";
                source.method_9213((class_2561)new class_2588("minebackup.message.list_configs.fail", new Object[]{error}));
                return;
            }
            class_2588 resultText = new class_2588("minebackup.message.list_configs.success.title");
            String data = response.substring(3);
            if (data.isEmpty()) {
                resultText.method_10852((class_2561)new class_2588("minebackup.message.list_configs.empty"));
            } else {
                for (String config : data.split(";")) {
                    String[] parts = config.split(",", 2);
                    if (parts.length != 2) continue;
                    resultText.method_10852((class_2561)new class_2588("minebackup.message.list_configs.success.entry", new Object[]{parts[0], parts[1]}));
                }
            }
            source.method_9226((class_2561)resultText, false);
        });
    }

    private static void handleListWorldsResponse(class_2168 source, String response, int configId) {
        source.method_9211().execute(() -> {
            if (response == null || !response.startsWith("OK:")) {
                source.method_9213((class_2561)new class_2588("minebackup.message.list_worlds.fail", new Object[]{response != null ? response : "No response"}));
                return;
            }
            class_2588 resultText = new class_2588("minebackup.message.list_worlds.success.title", new Object[]{String.valueOf(configId)});
            String data = response.substring(3);
            if (data.isEmpty()) {
                resultText.method_10852((class_2561)new class_2588("minebackup.message.list_worlds.empty"));
            } else {
                String[] worlds = data.split(";");
                for (int i = 0; i < worlds.length; ++i) {
                    resultText.method_10852((class_2561)new class_2588("minebackup.message.list_worlds.success.entry", new Object[]{String.valueOf(i), worlds[i]}));
                }
            }
            source.method_9226((class_2561)resultText, false);
        });
    }

    private static void handleListBackupsResponse(class_2168 source, String response, int configId, int worldIndex) {
        source.method_9211().execute(() -> {
            if (response == null || !response.startsWith("OK:")) {
                source.method_9213((class_2561)new class_2588("minebackup.message.list_backups.fail", new Object[]{response != null ? response : "No response"}));
                return;
            }
            class_2588 resultText = new class_2588("minebackup.message.list_backups.success.title", new Object[]{String.valueOf(configId), String.valueOf(worldIndex)});
            String data = response.substring(3);
            if (data.isEmpty()) {
                resultText.method_10852((class_2561)new class_2588("minebackup.message.list_backups.empty"));
            } else {
                for (String file : data.split(";")) {
                    if (file.isEmpty()) continue;
                    resultText.method_10852((class_2561)new class_2588("minebackup.message.list_backups.success.entry", new Object[]{file}));
                }
            }
            source.method_9226((class_2561)resultText, false);
        });
    }

    private static CompletableFuture<Suggestions> suggestBackupFiles(int configId, int worldIndex, SuggestionsBuilder builder) {
        String command = String.format("LIST_BACKUPS %d %d", configId, worldIndex);
        return OpenSocketQuerier.query(QUERIER_APP_ID, QUERIER_SOCKET_ID, command).thenApply(response -> {
            if (response != null && response.startsWith("OK:")) {
                String[] files;
                String data = response.substring(3);
                for (String file : files = data.split(";")) {
                    if (file.isEmpty() || !file.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                    builder.suggest(file);
                }
            }
            return builder.build();
        });
    }
}

