/*
 * Decompiled with CFR 0.152.
 */
package com.leafuke.minebackup;

import com.leafuke.minebackup.Command;
import com.leafuke.minebackup.knotlink.SignalSubscriber;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MineBackup
implements ModInitializer {
    public static final String MOD_ID = "minebackup";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"minebackup");
    private static SignalSubscriber knotLinkSubscriber;
    private static volatile MinecraftServer serverInstance;
    public static final String BROADCAST_APP_ID = "0x00000020";
    public static final String BROADCAST_SIGNAL_ID = "0x00000020";

    public void onInitialize() {
        LOGGER.info("Initializing MineBackup for Fabric...");
        this.registerServerLifecycleEvents();
        this.registerCommands();
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> Command.register((CommandDispatcher<class_2168>)dispatcher));
    }

    private void registerServerLifecycleEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            LOGGER.info("MineBackup Mod: Server is starting, initializing KnotLink Subscriber...");
            serverInstance = server;
            knotLinkSubscriber = new SignalSubscriber("0x00000020", "0x00000020");
            knotLinkSubscriber.setSignalListener(this::handleBroadcastEvent);
            new Thread(knotLinkSubscriber::start).start();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            LOGGER.info("MineBackup Mod: Server is stopping, shutting down KnotLink Subscriber...");
            if (knotLinkSubscriber != null) {
                knotLinkSubscriber.stop();
            }
            serverInstance = null;
        });
    }

    private Map<String, String> parsePayload(String payload) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (payload == null || payload.isEmpty()) {
            return dataMap;
        }
        for (String pair : payload.split(";")) {
            String[] keyValue = pair.split("=", 2);
            if (keyValue.length != 2) continue;
            dataMap.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return dataMap;
    }

    private void handleBroadcastEvent(String payload) {
        if (serverInstance == null) {
            return;
        }
        if ("minebackup save".equals(payload)) {
            serverInstance.execute(() -> {
                LOGGER.info("Received 'minebackup save' command, executing immediate world save.");
                serverInstance.method_3760().method_14616((class_2561)new class_2588("minebackup.message.remote_save.start"), class_2556.field_11735, class_156.field_25140);
                boolean allLevelsSaved = serverInstance.method_3723(true, true, true);
                if (allLevelsSaved) {
                    serverInstance.method_3760().method_14616((class_2561)new class_2588("minebackup.message.remote_save.success"), class_2556.field_11735, class_156.field_25140);
                } else {
                    serverInstance.method_3760().method_14616((class_2561)new class_2588("minebackup.message.remote_save.fail"), class_2556.field_11735, class_156.field_25140);
                }
            });
            return;
        }
        LOGGER.info("Received MineBackup broadcast event: {}", (Object)payload);
        Map<String, String> eventData = this.parsePayload(payload);
        String eventType = eventData.get("event");
        if (eventType == null) {
            return;
        }
        class_2588 message = null;
        switch (eventType) {
            case "backup_started": {
                message = new class_2588("minebackup.broadcast.backup.started", new Object[]{eventData.getOrDefault("world", "unknown")});
                break;
            }
            case "restore_started": {
                message = new class_2588("minebackup.broadcast.restore.started", new Object[]{eventData.getOrDefault("world", "unknown")});
                break;
            }
            case "backup_success": {
                message = new class_2588("minebackup.broadcast.backup.success", new Object[]{eventData.getOrDefault("world", "unknown"), eventData.getOrDefault("file", "unknown")});
                break;
            }
            case "backup_failed": {
                message = new class_2588("minebackup.broadcast.backup.failed", new Object[]{eventData.getOrDefault("world", "unknown"), eventData.getOrDefault("error", "unknown")});
                break;
            }
            case "game_session_end": {
                message = new class_2588("minebackup.broadcast.session.end", new Object[]{eventData.getOrDefault("world", "\u672a\u77e5\u4e16\u754c")});
                break;
            }
            case "auto_backup_started": {
                message = new class_2588("minebackup.broadcast.auto_backup.started", new Object[]{eventData.getOrDefault("world", "\u672a\u77e5\u4e16\u754c")});
            }
        }
        if ("pre_hot_backup".equals(eventType)) {
            serverInstance.execute(() -> {
                LOGGER.info("Executing immediate save for pre_hot_backup event.");
                String worldName = eventData.getOrDefault("world", "\u672a\u77e5\u4e16\u754c");
                serverInstance.method_3760().method_14616((class_2561)new class_2588("minebackup.broadcast.hot_backup.request", new Object[]{worldName}), class_2556.field_11735, class_156.field_25140);
                boolean allSaved = serverInstance.method_3723(true, true, true);
                if (!allSaved) {
                    LOGGER.warn("One or more levels failed to save during pre_hot_backup for world: {}", (Object)worldName);
                    serverInstance.method_3760().method_14616((class_2561)new class_2588("minebackup.broadcast.hot_backup.warn", new Object[]{worldName}), class_2556.field_11735, class_156.field_25140);
                }
                LOGGER.info("World saved successfully for hot backup.");
                serverInstance.method_3760().method_14616((class_2561)new class_2588("minebackup.broadcast.hot_backup.complete"), class_2556.field_11735, class_156.field_25140);
            });
        } else if ("game_session_start".equals(eventType)) {
            LOGGER.info("MineBackup detected game session start for world: {}", (Object)eventData.getOrDefault("world", "\u672a\u77e5"));
        }
        if (message != null) {
            class_2588 finalMessage = message;
            serverInstance.execute(() -> MineBackup.lambda$handleBroadcastEvent$5((class_2561)finalMessage));
        }
    }

    private static /* synthetic */ void lambda$handleBroadcastEvent$5(class_2561 finalMessage) {
        serverInstance.method_3760().method_14616(finalMessage, class_2556.field_11735, class_156.field_25140);
    }
}

