/*
 * Decompiled with CFR 0.152.
 */
package com.leafuke.minebackup;

import com.leafuke.minebackup.Command;
import com.leafuke.minebackup.MineBackupClient;
import com.leafuke.minebackup.knotlink.OpenSocketQuerier;
import com.leafuke.minebackup.knotlink.SignalSender;
import com.leafuke.minebackup.knotlink.SignalSubscriber;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="minebackup")
public class MineBackup {
    public static final String MOD_ID = "minebackup";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"minebackup");
    private static SignalSubscriber knotLinkSubscriber = null;
    private static volatile MinecraftServer serverInstance;
    public static final String BROADCAST_APP_ID = "0x00000020";
    public static final String BROADCAST_SIGNAL_ID = "0x00000020";
    private static final String QUERIER_APP_ID = "0x00000020";
    private static final String QUERIER_SOCKET_ID = "0x00000010";

    public MineBackup() {
        LOGGER.info("Initializing MineBackup for Forge 1.20.1...");
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (FMLLoader.getDist().isClient()) {
            MineBackupClient.initialize();
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        Command.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        if (knotLinkSubscriber == null) {
            LOGGER.info("MineBackup Mod: Server is starting, initializing KnotLink Subscriber...");
            serverInstance = event.getServer();
            knotLinkSubscriber = new SignalSubscriber("0x00000020", "0x00000020");
            knotLinkSubscriber.setSignalListener(this::handleBroadcastEvent);
            new Thread(knotLinkSubscriber::start).start();
        }
    }

    private Map<String, String> parsePayload(String payload) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (payload == null || payload.isEmpty()) {
            return dataMap;
        }
        for (String pair : payload.split(";")) {
            String[] keyValue = pair.split("=", 2);
            if (keyValue.length != 2) continue;
            dataMap.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return dataMap;
    }

    private static void BroadcastEvent(String event) {
        SignalSender sender = new SignalSender("0x00000020", "0x00000020");
        sender.emitt(event);
    }

    private void handleBroadcastEvent(String payload) {
        MutableComponent message;
        if (serverInstance == null) {
            return;
        }
        if ("minebackup save".equals(payload)) {
            serverInstance.execute(() -> {
                LOGGER.info("Received 'minebackup save' command, executing immediate world save.");
                serverInstance.m_6846_().m_240416_((Component)Component.m_237115_((String)"minebackup.message.remote_save.start"), false);
                boolean allLevelsSaved = serverInstance.m_129885_(true, true, true);
                if (allLevelsSaved) {
                    serverInstance.m_6846_().m_240416_((Component)Component.m_237115_((String)"minebackup.message.remote_save.success"), false);
                } else {
                    serverInstance.m_6846_().m_240416_((Component)Component.m_237115_((String)"minebackup.message.remote_save.fail"), false);
                }
            });
            return;
        }
        LOGGER.info("Received MineBackup broadcast event: {}", (Object)payload);
        Map<String, String> eventData = this.parsePayload(payload);
        String eventType = eventData.get("event");
        if (eventType == null) {
            return;
        }
        if ("pre_hot_restore".equals(eventType)) {
            LOGGER.info("Received 'pre_hot_restore'. Preparing for hot restore.");
            serverInstance.execute(() -> {
                serverInstance.m_6846_().m_240416_((Component)Component.m_237115_((String)"minebackup.message.restore.preparing"), false);
                if (serverInstance.m_6982_()) {
                    LOGGER.info("Dedicated server detected. Kicking all players and stopping.");
                    List playerList = serverInstance.m_6846_().m_11314_();
                    MutableComponent kickMessage = Component.m_237115_((String)"minebackup.message.restore.kick");
                    for (ServerPlayer player : playerList) {
                        player.f_8906_.m_9942_((Component)kickMessage);
                    }
                    OpenSocketQuerier.query("0x00000020", QUERIER_SOCKET_ID, "SHUTDOWN_WORLD_SUCCESS");
                    serverInstance.m_7041_();
                } else {
                    String levelId;
                    LOGGER.info("Single-player instance detected. Saving and disconnecting player.");
                    MineBackupClient.worldToRejoin = levelId = serverInstance.m_129910_().m_5462_();
                    serverInstance.m_129885_(true, false, true);
                    ServerPlayer singlePlayer = (ServerPlayer)serverInstance.m_6846_().m_11314_().get(0);
                    MutableComponent kickMessage = Component.m_237115_((String)"minebackup.message.restore.kick");
                    singlePlayer.f_8906_.m_9942_((Component)kickMessage);
                    OpenSocketQuerier.query("0x00000020", QUERIER_SOCKET_ID, "SHUTDOWN_WORLD_SUCCESS");
                }
            });
            return;
        }
        if ("restore_finished".equals(eventType)) {
            MineBackupClient.readyToRejoin = true;
            LOGGER.info("Restore successful. Flagging client to rejoin world.");
            return;
        }
        switch (eventType) {
            case "backup_started": {
                MutableComponent mutableComponent = Component.m_237110_((String)"minebackup.broadcast.backup.started", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "restore_started": {
                MutableComponent mutableComponent = Component.m_237110_((String)"minebackup.broadcast.restore.started", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "backup_success": {
                MutableComponent mutableComponent = Component.m_237110_((String)"minebackup.broadcast.backup.success", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World"), eventData.getOrDefault("file", "\u672a\u77e5\u6587\u4ef6")});
                break;
            }
            case "backup_failed": {
                MutableComponent mutableComponent = Component.m_237110_((String)"minebackup.broadcast.backup.failed", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World"), eventData.getOrDefault("error", "\u672a\u77e5\u9519\u8bef")});
                break;
            }
            case "game_session_end": {
                MutableComponent mutableComponent = Component.m_237110_((String)"minebackup.broadcast.session.end", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "auto_backup_started": {
                MutableComponent mutableComponent = Component.m_237110_((String)"minebackup.broadcast.auto_backup.started", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "we_snapshot_completed": {
                MutableComponent mutableComponent = Component.m_237110_((String)"minebackup.broadcast.we_snapshot.completed", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World"), eventData.getOrDefault("file", "\u672a\u77e5\u6587\u4ef6")});
                break;
            }
            default: {
                MutableComponent mutableComponent = message = null;
            }
        }
        if ("pre_hot_backup".equals(eventType)) {
            serverInstance.execute(() -> {
                LOGGER.info("Executing immediate save for pre_hot_backup event.");
                String worldName = eventData.getOrDefault("world", "Unknown World");
                serverInstance.m_6846_().m_240416_((Component)Component.m_237110_((String)"minebackup.broadcast.hot_backup.request", (Object[])new Object[]{worldName}), false);
                boolean allSaved = serverInstance.m_129885_(true, true, true);
                if (!allSaved) {
                    LOGGER.warn("One or more levels failed to save during pre_hot_backup for world: {}", (Object)worldName);
                    serverInstance.m_6846_().m_240416_((Component)Component.m_237110_((String)"minebackup.broadcast.hot_backup.warn", (Object[])new Object[]{worldName}), false);
                }
                LOGGER.info("World saved successfully for hot backup.");
                serverInstance.m_6846_().m_240416_((Component)Component.m_237115_((String)"minebackup.broadcast.hot_backup.complete"), false);
            });
        } else if ("game_session_start".equals(eventType)) {
            LOGGER.info("MineBackup detected game session start for world: {}", (Object)eventData.getOrDefault("world", "Unknown World"));
        }
        if (message != null) {
            serverInstance.execute(() -> MineBackup.lambda$handleBroadcastEvent$3((Component)message));
        }
    }

    private static /* synthetic */ void lambda$handleBroadcastEvent$3(Component message) {
        serverInstance.m_6846_().m_240416_(message, false);
    }
}

