/*
 * Decompiled with CFR 0.152.
 */
package com.leafuke.minebackup;

import com.leafuke.minebackup.MineBackup;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MineBackupClient {
    public static String worldToRejoin = null;
    public static boolean readyToRejoin = false;

    public static void initialize() {
        MinecraftForge.EVENT_BUS.register((Object)new MineBackupClient());
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && readyToRejoin) {
            Minecraft client = Minecraft.m_91087_();
            client.m_91152_((Screen)new TitleScreen());
            readyToRejoin = false;
            String levelId = worldToRejoin;
            worldToRejoin = null;
            if (levelId != null) {
                MineBackup.LOGGER.info("Attempting to automatically rejoin world: {}", (Object)levelId);
                try {
                    client.execute(() -> this.attemptAutoRejoin(client, levelId));
                }
                catch (Exception e) {
                    MineBackup.LOGGER.error("Failed while attempting auto-rejoin handling.", (Throwable)e);
                }
            }
        }
    }

    private void attemptAutoRejoin(Minecraft client, String levelId) {
        try {
            if (client.f_91074_ != null) {
                client.f_91074_.m_213846_((Component)Component.m_237115_((String)"minebackup.message.restore.rejoining"));
            } else {
                MineBackup.LOGGER.info("Client player is null; will still try to start integrated server for '{}'.", (Object)levelId);
            }
            boolean integratedRunning = MineBackupClient.invokeBooleanPossibleMethods(client, "isSingleplayer", "isIntegratedServerRunning", "isLocalServerRunning");
            if (!integratedRunning) {
                boolean bl = integratedRunning = client.f_91073_ != null;
            }
            if (integratedRunning) {
                try {
                    MineBackupClient.safeInvokeDisconnect(client, (Component)Component.m_237115_((String)"minebackup.message.restore.rejoining"));
                }
                catch (Exception e) {
                    MineBackup.LOGGER.warn("Error while disconnecting existing integrated server: {}", (Object)e.getMessage());
                }
            }
            try {
                MineBackupClient.deleteSessionLockForLevel(client, levelId);
            }
            catch (Exception e) {
                MineBackup.LOGGER.warn("Could not delete session lock for '{}': {}", (Object)levelId, (Object)e.getMessage());
            }
            client.m_91152_((Screen)new SimpleMessageScreen((Component)Component.m_237115_((String)"minebackup.message.restore.rejoining")));
            boolean started = MineBackupClient.tryStartIntegratedServer(client, levelId);
            if (!started) {
                MineBackup.LOGGER.warn("Could not start integrated server; falling back to SelectWorldScreen for manual join.");
                client.m_91152_((Screen)new SelectWorldScreen((Screen)new TitleScreen()));
            }
        }
        catch (Exception e) {
            MineBackup.LOGGER.error("Auto rejoin failed for world '{}': {}", (Object)levelId, (Object)e);
            try {
                client.m_91152_((Screen)new SelectWorldScreen((Screen)new TitleScreen()));
            }
            catch (Exception ex) {
                MineBackup.LOGGER.warn("Failed to open SelectWorldScreen after auto-rejoin failure: {}", (Object)ex.getMessage());
            }
        }
    }

    private static boolean invokeBooleanPossibleMethods(Object target, String ... methodNames) {
        for (String name : methodNames) {
            try {
                Method m = target.getClass().getMethod(name, new Class[0]);
                Object res = m.invoke(target, new Object[0]);
                if (!(res instanceof Boolean)) continue;
                return (Boolean)res;
            }
            catch (NoSuchMethodException m) {
            }
            catch (Exception e) {
                MineBackup.LOGGER.debug("invokeBooleanPossibleMethods '{}' failed: {}", (Object)name, (Object)e.getMessage());
            }
        }
        return false;
    }

    private static void safeInvokeDisconnect(Minecraft client, Component notice) {
        try {
            Method m = client.getClass().getMethod("disconnect", Screen.class);
            m.invoke((Object)client, new Object[]{new SimpleMessageScreen(notice)});
            return;
        }
        catch (NoSuchMethodException m) {
        }
        catch (Exception e) {
            MineBackup.LOGGER.debug("disconnect(Screen) failed: {}", (Object)e.getMessage());
        }
        try {
            client.m_91152_((Screen)new SimpleMessageScreen(notice));
        }
        catch (Exception e) {
            MineBackup.LOGGER.debug("Fallback setScreen message failed: {}", (Object)e.getMessage());
        }
    }

    private static void deleteSessionLockForLevel(Minecraft client, String levelId) {
        Object levelSource = MineBackupClient.invokeFirstNoArgMethod(client, "getLevelSource", "getLevelStorage", "getSaveLoader");
        if (levelSource == null) {
            MineBackup.LOGGER.debug("No level storage/source object found via reflection.");
            return;
        }
        Optional<Method> createAccess = MineBackupClient.findMethodByNameAndParamCount(levelSource.getClass(), new String[]{"createAccess"}, 1);
        if (createAccess.isPresent()) {
            try {
                Object access = createAccess.get().invoke(levelSource, levelId);
                if (access != null) {
                    MineBackupClient.tryInvokeNoArgOnObject(access, "deleteLock", "close", "deleteSessionLock");
                }
            }
            catch (Exception e) {
                MineBackup.LOGGER.debug("createAccess invocation failed: {}", (Object)e.getMessage());
            }
        }
    }

    private static Object invokeFirstNoArgMethod(Object target, String ... methodNames) {
        for (String name : methodNames) {
            try {
                Method m = target.getClass().getMethod(name, new Class[0]);
                return m.invoke(target, new Object[0]);
            }
            catch (NoSuchMethodException m) {
            }
            catch (Exception e) {
                MineBackup.LOGGER.debug("invokeFirstNoArgMethod '{}' failed: {}", (Object)name, (Object)e.getMessage());
            }
        }
        return null;
    }

    private static Optional<Method> findMethodByNameAndParamCount(Class<?> cls, String[] names, int paramCount) {
        for (String name : names) {
            for (Method m : cls.getMethods()) {
                if (!m.getName().equals(name) || m.getParameterCount() != paramCount) continue;
                return Optional.of(m);
            }
        }
        return Optional.empty();
    }

    private static void tryInvokeNoArgOnObject(Object target, String ... methodNames) {
        for (String name : methodNames) {
            try {
                Method m = target.getClass().getMethod(name, new Class[0]);
                m.invoke(target, new Object[0]);
                MineBackup.LOGGER.debug("Successfully invoked '{}' on {}", (Object)name, (Object)target.getClass().getName());
                return;
            }
            catch (NoSuchMethodException m) {
            }
            catch (Exception e) {
                MineBackup.LOGGER.debug("tryInvokeNoArgOnObject '{}' failed: {}", (Object)name, (Object)e.getMessage());
            }
        }
    }

    private static boolean tryStartIntegratedServer(Minecraft client, String levelId) {
        String[] fallbacks;
        try {
            Object worldOpenFlows = MineBackupClient.invokeFirstNoArgMethod(client, "createWorldOpenFlows");
            if (worldOpenFlows != null) {
                Method loadLevel = worldOpenFlows.getClass().getMethod("loadLevel", Screen.class, String.class);
                loadLevel.invoke(worldOpenFlows, new TitleScreen(), levelId);
                return true;
            }
        }
        catch (Exception e) {
            MineBackup.LOGGER.debug("createWorldOpenFlows().loadLevel() reflection failed: {}", (Object)e.getMessage());
        }
        for (String name : fallbacks = new String[]{"startIntegratedServer", "loadLevel"}) {
            try {
                for (Method m : client.getClass().getMethods()) {
                    if (!m.getName().equals(name) || m.getParameterCount() != 1 || m.getParameterTypes()[0] != String.class) continue;
                    m.invoke((Object)client, levelId);
                    return true;
                }
            }
            catch (Exception e) {
                MineBackup.LOGGER.debug("{} invocation failed: {}", (Object)name, (Object)e.getMessage());
            }
        }
        return false;
    }

    private static class SimpleMessageScreen
    extends Screen {
        private final Component message;

        protected SimpleMessageScreen(Component message) {
            super((Component)Component.m_237119_());
            this.message = message;
        }

        protected void m_7856_() {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.back"), b -> this.f_96541_.m_91152_(null)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 20, 200, 20).m_253136_());
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            guiGraphics.m_280653_(this.f_96547_, this.message, this.f_96543_ / 2, this.f_96544_ / 2 - 10, 0xFFFFFF);
        }

        public boolean m_6913_() {
            return true;
        }
    }
}

