/*
 * Decompiled with CFR 0.152.
 */
package com.leafuke.minebackup.knotlink;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TcpClient {
    private Socket socket;
    private PrintWriter out;
    private InputStream in;
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private String heartbeatMessage = "heartbeat";
    private String heartbeatResponse = "heartbeat_response";
    private boolean running = false;
    private DataReceivedListener dataReceivedListener;

    public boolean connectToServer(String host, int port) {
        try {
            this.socket = new Socket(host, port);
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            this.in = this.socket.getInputStream();
            System.out.println("Connected to server at " + host + ":" + port);
            new Thread(this::readData).start();
            this.startHeartbeat();
            return true;
        }
        catch (IOException e) {
            System.err.println("Failed to connect to server: " + e.getMessage());
            return false;
        }
    }

    public void sendData(String data) {
        if (this.out != null) {
            this.out.print(data);
            this.out.flush();
        } else {
            System.err.println("Socket is not connected.");
        }
    }

    private void startHeartbeat() {
        this.running = true;
        this.scheduler.scheduleAtFixedRate(() -> {
            if (this.running) {
                this.sendData(this.heartbeatMessage);
            }
        }, 1L, 3L, TimeUnit.MINUTES);
    }

    private void stopHeartbeat() {
        this.running = false;
        this.scheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readData() {
        System.out.println("DEBUG: Start reading from server...");
        try {
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = this.in.read(buffer)) != -1) {
                String receivedData = new String(buffer, 0, bytesRead);
                System.out.println("Received raw data: " + receivedData);
                if (receivedData.trim().equals(this.heartbeatResponse) || this.dataReceivedListener == null) continue;
                this.dataReceivedListener.onDataReceived(receivedData);
            }
        }
        catch (IOException e) {
            System.err.println("Socket error: " + e.getMessage());
        }
        finally {
            this.stopHeartbeat();
            System.out.println("Server disconnected.");
        }
    }

    public void setDataReceivedListener(DataReceivedListener listener) {
        this.dataReceivedListener = listener;
        System.out.println("DataReceivedListener set successfully.");
    }

    public void close() {
        this.stopHeartbeat();
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            System.err.println("Error closing socket: " + e.getMessage());
        }
    }

    public static interface DataReceivedListener {
        public void onDataReceived(String var1);
    }
}

