/*
 * Decompiled with CFR 0.152.
 */
package com.leafuke.minebackup;

import com.leafuke.minebackup.knotlink.OpenSocketQuerier;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;

public class Command {
    private static final String QUERIER_APP_ID = "0x00000020";
    private static final String QUERIER_SOCKET_ID = "0x00000010";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"minebackup").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"save").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            MinecraftServer server = source.m_81377_();
            source.m_288197_(() -> Component.m_237115_((String)"minebackup.message.save.start"), true);
            for (ServerLevel level : server.m_129785_()) {
                level.m_8643_(null, true, false);
            }
            source.m_288197_(() -> Component.m_237115_((String)"minebackup.message.save.success"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"list_configs").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"minebackup.message.list_configs.start"), false);
            Command.queryBackend("LIST_CONFIGS", response -> Command.handleListConfigsResponse((CommandSourceStack)ctx.getSource(), response));
            return 1;
        }))).then(Commands.m_82127_((String)"list_worlds").then(Commands.m_82129_((String)"config_id", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            int configId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id");
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"minebackup.message.list_worlds.start", (Object[])new Object[]{configId}), false);
            Command.queryBackend(String.format("LIST_WORLDS %d", configId), response -> Command.handleListWorldsResponse((CommandSourceStack)ctx.getSource(), response, configId));
            return 1;
        })))).then(Commands.m_82127_((String)"list_backups").then(Commands.m_82129_((String)"config_id", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"world_index", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            int configId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id");
            int worldIndex = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index");
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"minebackup.message.list_backups.start", (Object[])new Object[]{configId, worldIndex}), false);
            Command.queryBackend(String.format("LIST_BACKUPS %d %d", configId, worldIndex), response -> Command.handleListBackupsResponse((CommandSourceStack)ctx.getSource(), response, configId, worldIndex));
            return 1;
        }))))).then(Commands.m_82127_((String)"backup").then(Commands.m_82129_((String)"config_id", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"world_index", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> Command.executeRemoteCommand((CommandSourceStack)ctx.getSource(), String.format("BACKUP %d %d", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index"))))).then(Commands.m_82129_((String)"comment", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> Command.executeRemoteCommand((CommandSourceStack)ctx.getSource(), String.format("BACKUP %d %d %s", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index"), StringArgumentType.getString((CommandContext)ctx, (String)"comment"))))))))).then(Commands.m_82127_((String)"restore").then(Commands.m_82129_((String)"config_id", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"world_index", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"backup_file", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> Command.suggestBackupFiles(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index"), builder)).executes(ctx -> Command.executeRemoteCommand((CommandSourceStack)ctx.getSource(), String.format("RESTORE %d %d %s", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index"), StringArgumentType.getString((CommandContext)ctx, (String)"backup_file"))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"quicksave").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            MinecraftServer server = source.m_81377_();
            source.m_288197_(() -> Component.m_237115_((String)"minebackup.message.save.start"), true);
            for (ServerLevel level : server.m_129785_()) {
                level.m_8643_(null, true, false);
            }
            source.m_288197_(() -> Component.m_237115_((String)"minebackup.message.save.success"), true);
            return 1;
        })).executes(ctx -> Command.executeRemoteCommand((CommandSourceStack)ctx.getSource(), "BACKUP_CURRENT"))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"comment", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            MinecraftServer server = source.m_81377_();
            source.m_288197_(() -> Component.m_237115_((String)"minebackup.message.save.start"), true);
            for (ServerLevel level : server.m_129785_()) {
                level.m_8643_(null, true, false);
            }
            source.m_288197_(() -> Component.m_237115_((String)"minebackup.message.save.success"), true);
            return 1;
        })).executes(ctx -> Command.executeRemoteCommand((CommandSourceStack)ctx.getSource(), String.format("BACKUP_CURRENT %s", StringArgumentType.getString((CommandContext)ctx, (String)"comment"))))))).then(Commands.m_82127_((String)"auto").then(Commands.m_82129_((String)"config_id", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"world_index", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"internal_time", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> Command.executeRemoteCommand((CommandSourceStack)ctx.getSource(), String.format("AUTO_BACKUP %d %d %d", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"internal_time"))))))))).then(Commands.m_82127_((String)"stop").then(Commands.m_82129_((String)"config_id", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"world_index", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> Command.executeRemoteCommand((CommandSourceStack)ctx.getSource(), String.format("STOP_AUTO_BACKUP %d %d", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"config_id"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"world_index"))))))));
    }

    private static void queryBackend(String command, Consumer<String> callback) {
        OpenSocketQuerier.query(QUERIER_APP_ID, QUERIER_SOCKET_ID, command).thenAccept((Consumer)callback);
    }

    private static int executeRemoteCommand(CommandSourceStack source, String command) {
        source.m_288197_(() -> Component.m_237110_((String)"minebackup.message.command.sent", (Object[])new Object[]{command}), false);
        Command.queryBackend(command, response -> source.m_81377_().execute(() -> {
            if (response != null && response.startsWith("ERROR:")) {
                source.m_81352_((Component)Component.m_237110_((String)"minebackup.message.command.fail", (Object[])new Object[]{response.substring(6)}));
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"minebackup.message.command.response", (Object[])new Object[]{response}), false);
            }
        }));
        return 1;
    }

    private static void handleListConfigsResponse(CommandSourceStack source, String response) {
        source.m_81377_().execute(() -> {
            if (response == null || !response.startsWith("OK:")) {
                source.m_81352_((Component)Component.m_237110_((String)"minebackup.message.list_configs.fail", (Object[])new Object[]{response != null ? response : "\u65e0\u54cd\u5e94"}));
                return;
            }
            MutableComponent resultText = Component.m_237115_((String)"minebackup.message.list_configs.success.title");
            String data = response.substring(3);
            if (data.isEmpty()) {
                resultText.m_7220_((Component)Component.m_237115_((String)"minebackup.message.list_configs.empty"));
            } else {
                for (String config : data.split(";")) {
                    String[] parts = config.split(",", 2);
                    if (parts.length != 2) continue;
                    resultText.m_7220_((Component)Component.m_237110_((String)"minebackup.message.list_configs.success.entry", (Object[])new Object[]{parts[0], parts[1]}));
                }
            }
            source.m_288197_(() -> resultText, false);
        });
    }

    private static void handleListWorldsResponse(CommandSourceStack source, String response, int configId) {
        source.m_81377_().execute(() -> {
            if (response == null || !response.startsWith("OK:")) {
                source.m_81352_((Component)Component.m_237110_((String)"minebackup.message.list_worlds.fail", (Object[])new Object[]{response != null ? response : "\u65e0\u54cd\u5e94"}));
                return;
            }
            MutableComponent resultText = Component.m_237110_((String)"minebackup.message.list_worlds.success.title", (Object[])new Object[]{configId});
            String data = response.substring(3);
            if (data.isEmpty()) {
                resultText.m_7220_((Component)Component.m_237115_((String)"minebackup.message.list_worlds.empty"));
            } else {
                String[] worlds = data.split(";");
                for (int i = 0; i < worlds.length; ++i) {
                    resultText.m_7220_((Component)Component.m_237110_((String)"minebackup.message.list_worlds.success.entry", (Object[])new Object[]{i, worlds[i]}));
                }
            }
            source.m_288197_(() -> resultText, false);
        });
    }

    private static void handleListBackupsResponse(CommandSourceStack source, String response, int configId, int worldIndex) {
        source.m_81377_().execute(() -> {
            if (response == null || !response.startsWith("OK:")) {
                source.m_81352_((Component)Component.m_237110_((String)"minebackup.message.list_backups.fail", (Object[])new Object[]{response != null ? response : "\u65e0\u54cd\u5e94"}));
                return;
            }
            MutableComponent resultText = Component.m_237110_((String)"minebackup.message.list_backups.success.title", (Object[])new Object[]{configId, worldIndex});
            String data = response.substring(3);
            if (data.isEmpty()) {
                resultText.m_7220_((Component)Component.m_237115_((String)"minebackup.message.list_backups.empty"));
            } else {
                for (String file : data.split(";")) {
                    if (file.isEmpty()) continue;
                    resultText.m_7220_((Component)Component.m_237110_((String)"minebackup.message.list_backups.success.entry", (Object[])new Object[]{file}));
                }
            }
            source.m_288197_(() -> resultText, false);
        });
    }

    private static CompletableFuture<Suggestions> suggestBackupFiles(int configId, int worldIndex, SuggestionsBuilder builder) {
        String command = String.format("LIST_BACKUPS %d %d", configId, worldIndex);
        return OpenSocketQuerier.query(QUERIER_APP_ID, QUERIER_SOCKET_ID, command).thenApply(response -> {
            if (response != null && response.startsWith("OK:")) {
                String[] files;
                String data = response.substring(3);
                for (String file : files = data.split(";")) {
                    if (file.isEmpty() || !file.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                    builder.suggest(file);
                }
            }
            return builder.build();
        });
    }
}

