/*
 * Decompiled with CFR 0.152.
 */
package com.leafuke.minebackup;

import com.leafuke.minebackup.Command;
import com.leafuke.minebackup.knotlink.SignalSubscriber;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="minebackup")
public class MineBackup {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "minebackup";
    private static SignalSubscriber knotLinkSubscriber;
    private static MinecraftServer serverInstance;
    private static final String BROADCAST_APP_ID = "0x00000020";
    private static final String BROADCAST_SIGNAL_ID = "0x00000020";

    private Map<String, String> parsePayload(String payload) {
        String[] pairs;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (payload == null || payload.isEmpty()) {
            return dataMap;
        }
        for (String pair : pairs = payload.split(";")) {
            String[] keyValue = pair.split("=", 2);
            if (keyValue.length != 2) continue;
            dataMap.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return dataMap;
    }

    private void handleBroadcastEvent(String payload) {
        if (serverInstance == null) {
            return;
        }
        if ("minebackup save".equals(payload)) {
            serverInstance.execute(() -> {
                LOGGER.info("Received 'minebackup save' command, executing immediate world save.");
                serverInstance.m_6846_().m_240416_((Component)Component.m_237115_((String)"minebackup.message.remote_save.start"), false);
                boolean allLevelsSaved = serverInstance.m_129885_(true, true, true);
                if (allLevelsSaved) {
                    serverInstance.m_6846_().m_240416_((Component)Component.m_237115_((String)"minebackup.message.remote_save.success"), false);
                } else {
                    serverInstance.m_6846_().m_240416_((Component)Component.m_237115_((String)"minebackup.message.remote_save.fail"), false);
                }
            });
            return;
        }
        LOGGER.info("Received MineBackup broadcast event: {}", (Object)payload);
        Map<String, String> eventData = this.parsePayload(payload);
        String eventType = eventData.get("event");
        if (eventType == null) {
            return;
        }
        MutableComponent message = null;
        switch (eventType) {
            case "backup_started": {
                message = Component.m_237110_((String)"minebackup.broadcast.backup.started", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "restore_started": {
                message = Component.m_237110_((String)"minebackup.broadcast.restore.started", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "backup_success": {
                message = Component.m_237110_((String)"minebackup.broadcast.backup.success", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World"), eventData.getOrDefault("file", "Unknown File")});
                break;
            }
            case "backup_failed": {
                message = Component.m_237110_((String)"minebackup.broadcast.backup.failed", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World"), eventData.getOrDefault("error", "Unknown Error")});
                break;
            }
            case "pre_hot_backup": {
                serverInstance.execute(() -> {
                    LOGGER.info("Executing immediate save for pre_hot_backup event.");
                    String worldName = eventData.getOrDefault("world", "Unknown World");
                    boolean allSaved = serverInstance.m_129885_(true, true, true);
                    serverInstance.m_6846_().m_240416_((Component)Component.m_237110_((String)"minebackup.broadcast.hot_backup.request", (Object[])new Object[]{worldName}), false);
                    if (!allSaved) {
                        LOGGER.warn("One or more levels failed to save during pre_hot_backup for world: {}", (Object)worldName);
                        serverInstance.m_6846_().m_240416_((Component)Component.m_237110_((String)"minebackup.broadcast.hot_backup.warn", (Object[])new Object[]{worldName}), false);
                    }
                    for (ServerLevel level : serverInstance.m_129785_()) {
                        level.m_8643_(null, true, false);
                    }
                    LOGGER.info("World saved successfully for hot backup.");
                    serverInstance.m_6846_().m_240416_((Component)Component.m_237115_((String)"minebackup.broadcast.hot_backup.complete"), false);
                });
                break;
            }
            case "game_session_start": {
                LOGGER.info("MineBackup detected game session start for world: {}", (Object)eventData.getOrDefault("world", "\u672a\u77e5"));
                message = Component.m_237110_((String)"minebackup.broadcast.session.start", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "game_session_end": {
                LOGGER.info("MineBackup detected game session end for world: {}", (Object)eventData.getOrDefault("world", "\u672a\u77e5"));
                message = Component.m_237110_((String)"minebackup.broadcast.session.end", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
                break;
            }
            case "auto_backup_started": {
                message = Component.m_237110_((String)"minebackup.broadcast.auto_backup.started", (Object[])new Object[]{eventData.getOrDefault("world", "Unknown World")});
            }
        }
        if (message != null) {
            MutableComponent finalMessage = message;
            serverInstance.execute(() -> serverInstance.m_6846_().m_240416_(finalMessage, false));
        }
    }

    public MineBackup() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        Command.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public MineBackup(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("MineBackup Mod: Server is starting, initializing KnotLink Subscriber...");
        serverInstance = event.getServer();
        knotLinkSubscriber = new SignalSubscriber("0x00000020", "0x00000020");
        knotLinkSubscriber.setSignalListener(this::handleBroadcastEvent);
        new Thread(knotLinkSubscriber::start).start();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("MineBackup Mod: Server is stopping, shutting down KnotLink Subscriber...");
        if (knotLinkSubscriber != null) {
            knotLinkSubscriber.stop();
        }
        serverInstance = null;
    }

    @Mod.EventBusSubscriber(modid="minebackup", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
        }
    }
}

