/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retrocommands.command;

import com.matthewperiut.retrocommands.api.Command;
import com.matthewperiut.retrocommands.api.ItemInstanceStr;
import com.matthewperiut.retrocommands.util.ParameterSuggestUtil;
import com.matthewperiut.retrocommands.util.SharedCommandSource;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_127;
import net.minecraft.class_18;
import net.minecraft.class_206;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.util.Identifier;

public class Give
implements Command {
    public static boolean givePlayerItemInstance(SharedCommandSource commandSource, class_54 player, class_31 instance) {
        class_31[] inventory = player.field_519.field_745;
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] != null) continue;
            inventory[i] = instance;
            return true;
        }
        commandSource.sendFeedback("Cannot give " + instance.method_694().method_469() + " because inventory is full");
        return false;
    }

    public static int nameToItemId(String n) {
        String name = n.replace("_", "");
        for (int i = 0; i < class_124.field_468.length; ++i) {
            String translatedName;
            if (class_124.field_468[i] == null || !(translatedName = class_124.field_468[i].method_469().replace(" ", "")).equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public static int identifierToItemId(String n) {
        Optional item = ItemRegistry.INSTANCE.getOrEmpty(Identifier.of((String)n));
        return item.map(itemBase -> itemBase.field_461).orElse(-1);
    }

    @Override
    public void command(SharedCommandSource commandSource, String[] parameters) {
        if (parameters.length > 1 && !parameters[1].equals("help")) {
            int stackSize;
            class_124 itemType;
            String setSPCStr;
            int meta;
            block20: {
                int itemNumber;
                meta = 0;
                setSPCStr = "";
                try {
                    itemNumber = Integer.parseInt(parameters[1]);
                }
                catch (NumberFormatException e) {
                    int n = itemNumber = FabricLoader.getInstance().isModLoaded("station-registry-api-v0") ? Give.identifierToItemId(parameters[1]) : Give.nameToItemId(parameters[1]);
                }
                if (itemNumber == -1) {
                    commandSource.sendFeedback("Item not found");
                    return;
                }
                itemType = class_124.field_468[itemNumber];
                if (itemType == null) {
                    commandSource.sendFeedback("Item not found");
                    return;
                }
                stackSize = itemType.method_459();
                if (parameters.length > 2) {
                    int requestedCount;
                    try {
                        requestedCount = Integer.parseInt(parameters[2]);
                    }
                    catch (NumberFormatException e) {
                        commandSource.sendFeedback("Requested number of items '" + parameters[2] + "' is not a number");
                        return;
                    }
                    stackSize = requestedCount;
                    if (parameters.length > 3) {
                        if (itemType.method_462() || itemType.method_469().equals("Monster Spawner")) {
                            try {
                                meta = Integer.parseInt(parameters[3]);
                            }
                            catch (NumberFormatException e) {
                                if (itemType.method_469().equals("Monster Spawner")) {
                                    class_57 entity = class_206.method_732((String)parameters[3], (class_18)commandSource.getPlayer().field_1596);
                                    if (entity instanceof class_127) {
                                        class_127 l = (class_127)entity;
                                        setSPCStr = l.method_1337();
                                        commandSource.sendFeedback(l.method_1337() + " inside");
                                    } else if (entity != null) {
                                        commandSource.sendFeedback("Entity must be living in spawners");
                                    } else {
                                        commandSource.sendFeedback("Invalid entity parameter");
                                    }
                                    break block20;
                                }
                                commandSource.sendFeedback("Metadata not a number");
                            }
                        } else {
                            commandSource.sendFeedback("Metadata not applicable");
                        }
                    }
                }
            }
            class_31 item = new class_31(itemType, stackSize, meta);
            if (!setSPCStr.isEmpty()) {
                ((ItemInstanceStr)item).spc$setStr(setSPCStr);
            }
            if (Give.givePlayerItemInstance(commandSource, commandSource.getPlayer(), item)) {
                commandSource.sendFeedback("Gave " + item.field_751 + " " + itemType.method_469());
            }
            return;
        }
        this.manual(commandSource);
    }

    @Override
    public String name() {
        return "give";
    }

    @Override
    public void manual(SharedCommandSource commandSource) {
        commandSource.sendFeedback("Usage: /give {id} {count} {optional:meta/mob_id}");
        commandSource.sendFeedback("Info: gives the player items");
        commandSource.sendFeedback("id: can be number or name");
        commandSource.sendFeedback("count: number of item");
        commandSource.sendFeedback("meta: sub-item selection");
        commandSource.sendFeedback("list mobs with /mobs");
    }

    @Override
    public String[] suggestion(SharedCommandSource source, int parameterNum, String currentInput, String totalInput) {
        Optional id;
        String itemId;
        boolean hasModId;
        if (!FabricLoader.getInstance().isModLoaded("station-registry-api-v0")) {
            return new String[0];
        }
        if (parameterNum == 1) {
            return ParameterSuggestUtil.suggestItemIdentifier(currentInput);
        }
        if (parameterNum == 2 && currentInput.isEmpty() && (hasModId = (itemId = totalInput.split(" ")[1]).contains(":")) && (id = ItemRegistry.INSTANCE.getOrEmpty(Identifier.of((String)itemId))).isPresent()) {
            return new String[]{String.valueOf(((class_124)id.get()).method_459())};
        }
        return new String[0];
    }
}

