/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retrocommands.command;

import com.matthewperiut.retrocommands.api.Command;
import com.matthewperiut.retrocommands.util.SharedCommandSource;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.class_206;
import net.minecraft.class_25;
import net.minecraft.class_54;
import net.minecraft.class_57;

public class Ride
implements Command {
    @Override
    public void command(SharedCommandSource commandSource, String[] parameters) {
        class_54 player = commandSource.getPlayer();
        if (player == null) {
            return;
        }
        if (parameters.length < 3) {
            if (player.field_1595 != null) {
                player.method_1376(null);
                return;
            }
            this.manual(commandSource);
            return;
        }
        String rider = parameters[1];
        String vehicle = parameters[2];
        class_54 riderEntity = null;
        class_54 vehicleEntity = null;
        for (Object o : player.field_1596.field_200) {
            class_54 p = (class_54)o;
            if (p.field_528.equals(rider)) {
                riderEntity = p;
            }
            if (!p.field_528.equals(vehicle)) continue;
            vehicleEntity = p;
        }
        int riderId = -1;
        int vehicleId = -1;
        try {
            if (riderEntity == null) {
                riderId = Integer.parseInt(rider);
            }
            if (vehicleEntity == null) {
                vehicleId = Integer.parseInt(vehicle);
            }
        }
        catch (Exception e) {
            commandSource.sendFeedback("Invalid entity id");
        }
        for (Object o : player.field_1596.field_198) {
            class_57 e = (class_57)o;
            if (e.field_1591 == riderId) {
                riderEntity = e;
            }
            if (e.field_1591 != vehicleId) continue;
            vehicleEntity = e;
        }
        if (riderEntity == null || vehicleEntity == null) {
            commandSource.sendFeedback("Invalid entity id");
            return;
        }
        riderEntity.method_1376((class_57)vehicleEntity);
        String riderString = riderEntity instanceof class_54 ? riderEntity.field_528 : "The " + (String)class_206.field_758.get(riderEntity.getClass());
        String vehicleString = vehicleEntity instanceof class_54 ? vehicleEntity.field_528 : "the " + (String)class_206.field_758.get(vehicleEntity.getClass());
        commandSource.sendFeedback(riderString + " is now on " + vehicleString);
    }

    @Override
    public String name() {
        return "ride";
    }

    @Override
    public void manual(SharedCommandSource commandSource) {
        commandSource.sendFeedback("Usage: /ride {rider entity id} {vehicle entity id}");
        commandSource.sendFeedback("Info: Puts an entity on an entity");
        commandSource.sendFeedback("You can find entity id in the F3 menu");
        commandSource.sendFeedback("You can also use player names instead");
    }

    @Override
    public String[] suggestion(SharedCommandSource source, int parameterNum, String currentInput, String totalInput) {
        if (parameterNum == 1 || parameterNum == 2) {
            class_54 p = source.getPlayer();
            List entities = p.field_1596.method_175(class_57.class, class_25.method_87((double)(p.field_1600 - 20.0), (double)(p.field_1601 - 20.0), (double)(p.field_1602 - 20.0), (double)(p.field_1600 + 20.0), (double)(p.field_1601 + 20.0), (double)(p.field_1602 + 20.0)));
            TreeMap<Double, class_57> distanceMap = new TreeMap<Double, class_57>();
            for (class_57 entity2 : entities) {
                double distance = p.method_1351(entity2);
                while (distanceMap.containsKey(distance)) {
                    distance += 1.0E-4;
                }
                distanceMap.put(distance, entity2);
            }
            List<String> sortedEntityIDs = distanceMap.values().stream().map(entity -> {
                if (entity instanceof class_54) {
                    return ((class_54)entity).field_528;
                }
                return Integer.toString(entity.field_1591);
            }).collect(Collectors.toList());
            for (int i = sortedEntityIDs.size() - 1; i >= 0; --i) {
                if (!((String)sortedEntityIDs.get(i)).startsWith(currentInput)) {
                    sortedEntityIDs.remove(i);
                    continue;
                }
                if (parameterNum == 2) {
                    if (((String)sortedEntityIDs.get(i)).equals(totalInput.split(" ")[1])) {
                        sortedEntityIDs.remove(i);
                        continue;
                    }
                    sortedEntityIDs.set(i, ((String)sortedEntityIDs.get(i)).substring(currentInput.length()));
                    continue;
                }
                sortedEntityIDs.set(i, ((String)sortedEntityIDs.get(i)).substring(currentInput.length()));
            }
            return sortedEntityIDs.toArray(new String[0]);
        }
        return new String[0];
    }
}

