/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retrocommands.command;

import com.matthewperiut.retrocommands.api.Command;
import com.matthewperiut.retrocommands.api.PosParse;
import com.matthewperiut.retrocommands.command.server.ServerUtil;
import com.matthewperiut.retrocommands.optionaldep.stapi.SwitchDimension;
import com.matthewperiut.retrocommands.util.ParameterSuggestUtil;
import com.matthewperiut.retrocommands.util.SharedCommandSource;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_54;

public class Teleport
implements Command {
    public static void teleport(class_54 p, double x, double y, double z) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            p.method_1340(x, y, z);
            p.method_1365(0.0, 0.0, 0.0);
        } else {
            ServerUtil.serverTeleport(p, x, y, z);
        }
    }

    public static boolean switchDimensions(SharedCommandSource commandSource, String id) {
        if (FabricLoader.getInstance().isModLoaded("station-dimensions-v0")) {
            SwitchDimension.go(commandSource, id);
            return true;
        }
        commandSource.sendFeedback("Cannot switch dimensions without Station API Dimensions");
        return false;
    }

    @Override
    public void command(SharedCommandSource commandSource, String[] parameters) {
        class_54 player = commandSource.getPlayer();
        if (player == null) {
            commandSource.sendFeedback("You must be a player");
            return;
        }
        if (parameters.length == 2) {
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
                ServerUtil.teleportToPlayer(commandSource, player, parameters[1]);
                return;
            }
            commandSource.sendFeedback("You can only teleport to other players on server");
            return;
        }
        if (parameters.length == 3) {
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
                ServerUtil.teleportPlayerToPlayer(commandSource, parameters[1], parameters[2]);
                return;
            }
            commandSource.sendFeedback("You can only teleport to other players on server");
            return;
        }
        if (parameters.length > 3 && parameters.length < 7) {
            if (!PosParse.canPosParse(parameters[1])) {
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
                    PosParse pos = new PosParse(player, 2, parameters);
                    if (parameters.length == 6) {
                        ServerUtil.teleportPlayerToPos(commandSource, parameters[1], pos, parameters[5]);
                    } else {
                        ServerUtil.teleportPlayerToPos(commandSource, parameters[1], pos, "");
                    }
                    return;
                }
                commandSource.sendFeedback("This use of tp is reserved for server use");
                return;
            }
            PosParse pos = new PosParse(player, 1, parameters);
            if (!pos.valid) {
                commandSource.sendFeedback("Non-number position");
                return;
            }
            if (parameters.length > 4 && !Teleport.switchDimensions(commandSource, parameters[4])) {
                commandSource.sendFeedback("Dimension " + parameters[4] + " does not exist. No tp.");
                return;
            }
            commandSource.sendFeedback("Teleporting to " + String.valueOf(pos));
            Teleport.teleport(player, pos.x, pos.y, pos.z);
            return;
        }
        this.manual(commandSource);
    }

    @Override
    public String name() {
        return "tp";
    }

    @Override
    public void manual(SharedCommandSource commandSource) {
        commandSource.sendFeedback("Usage: /tp {x} {y} {z}");
        commandSource.sendFeedback("Usage: /tp {playerName}");
        commandSource.sendFeedback("Usage: /tp {teleport playerName} {to PlayerName}");
        commandSource.sendFeedback("Usage: /tp {playerName} {x} {y} {z}");
        commandSource.sendFeedback("Info: moves a player to a desired coordinate and/or dimension");
        commandSource.sendFeedback("Note: put dimension after other parameters to go to a dimension");
        commandSource.sendFeedback("dimension identifier: e.g. \"minecraft:overworld\"");
    }

    @Override
    public String[] suggestion(SharedCommandSource source, int parameterNum, String currentInput, String totalInput) {
        if (!(PosParse.canPosParse(currentInput) || parameterNum != 1 && parameterNum != 2)) {
            return ParameterSuggestUtil.suggestPlayerName(currentInput);
        }
        String[] segments = totalInput.split(" ");
        int offset = 0;
        if (segments.length > 1 && !PosParse.canPosParse(segments[1])) {
            ++offset;
            if (segments.length > 2 && !PosParse.canPosParse(segments[2])) {
                ++offset;
            }
        }
        if (parameterNum > offset && parameterNum < 4 + offset && currentInput.isEmpty()) {
            return new String[]{"~"};
        }
        return new String[0];
    }
}

