/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retrocommands.command.server;

import com.matthewperiut.retrocommands.api.PosParse;
import com.matthewperiut.retrocommands.command.Teleport;
import com.matthewperiut.retrocommands.command.server.Tpa;
import com.matthewperiut.retrocommands.dimension.BareTravelAgent;
import com.matthewperiut.retrocommands.util.SharedCommandSource;
import java.util.Optional;
import java.util.logging.Logger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_166;
import net.minecraft.class_467;
import net.minecraft.class_54;
import net.minecraft.class_69;
import net.minecraft.class_73;
import net.minecraft.server.MinecraftServer;
import net.modificationstation.stationapi.api.registry.DimensionRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.world.dimension.DimensionHelper;

public class ServerUtil {
    public static Logger LOGGER = Logger.getLogger("Minecraft");

    public static MinecraftServer getServer() {
        return (MinecraftServer)FabricLoader.getInstance().getGameInstance();
    }

    public static class_166 getConnectionManager() {
        return ServerUtil.getServer().field_2842;
    }

    public static void sendFeedbackAndLog(String user, String message) {
        String str = user + ": " + message;
        ServerUtil.getConnectionManager().method_588("\u00a77(" + str + ")");
        LOGGER.info(str);
    }

    public static String appendEnd(int start, String[] parameters) {
        StringBuilder joinedString = new StringBuilder();
        for (int i = start; i < parameters.length; ++i) {
            joinedString.append(parameters[i]).append(" ");
        }
        return joinedString.toString();
    }

    public static boolean isOp(String name) {
        return ServerUtil.getServer().field_2842.method_584(name);
    }

    public static void serverTeleport(class_54 p, double x, double y, double z) {
        class_69 sp = (class_69)p;
        sp.field_255.method_832(x, y, z, p.field_1606, p.field_1607);
    }

    public static void teleportPlayerToPos(SharedCommandSource source, String targetName, PosParse pos, String dim) {
        class_69 target = ServerUtil.getConnectionManager().method_586(targetName);
        if (target == null) {
            source.sendFeedback("Can't find user " + targetName + ". No tp.");
        } else {
            if (!dim.isEmpty() && !Teleport.switchDimensions(source, dim)) {
                source.sendFeedback("Dimension " + dim + " does not exist. No tp.");
                return;
            }
            Teleport.teleport((class_54)target, target.field_1600, target.field_1601, target.field_1602);
            source.sendFeedback("Teleporting " + targetName + " to " + String.valueOf(pos) + ".");
        }
    }

    @Environment(value=EnvType.SERVER)
    public static void teleportToPlayer(SharedCommandSource source, class_54 player, String targetName) {
        class_69 target = ServerUtil.getConnectionManager().method_586(targetName);
        if (target == null) {
            source.sendFeedback("Can't find user " + targetName + ". No tp.");
        } else {
            ServerUtil.switchDim(source, player, (class_54)target);
            Teleport.teleport(player, target.field_1600, target.field_1601, target.field_1602);
            source.sendFeedback("Teleporting " + player.field_528 + " to " + targetName + ".");
        }
    }

    @Environment(value=EnvType.SERVER)
    public static void teleportPlayerToPlayer(SharedCommandSource source, String playerName, String targetName) {
        class_69 player = ServerUtil.getConnectionManager().method_586(playerName);
        class_69 target = ServerUtil.getConnectionManager().method_586(targetName);
        if (player == null) {
            source.sendFeedback("Can't find user " + playerName + ". No tp.");
            return;
        }
        if (target == null) {
            source.sendFeedback("Can't find user " + targetName + ". No tp.");
            return;
        }
        ServerUtil.switchDim(source, (class_54)player, (class_54)target);
        Teleport.teleport((class_54)player, target.field_1600, target.field_1601, target.field_1602);
        source.sendFeedback("Teleporting " + player.field_528 + " to " + targetName + ".");
    }

    private static void switchDim(SharedCommandSource source, class_54 player, class_54 target) {
        if (player.field_529 != target.field_529) {
            if (!FabricLoader.getInstance().isModLoaded("station-dimensions-v0")) {
                source.sendFeedback("User " + player.field_528 + " and " + target.field_528 + " are in different dimensions. No tp.");
                return;
            }
            Optional dim = DimensionRegistry.INSTANCE.getId(target.field_529);
            if (dim.isPresent()) {
                DimensionHelper.switchDimension((class_54)player, (Identifier)((Identifier)dim.get()), (double)1.0, (class_467)new BareTravelAgent());
            } else {
                source.sendFeedback("User " + player.field_528 + " and " + target.field_528 + " are in different dimensions. No tp.");
                return;
            }
        }
    }

    public static void tpa(SharedCommandSource commandSource, String[] parameters) {
        class_54 player = commandSource.getPlayer();
        if (player == null) {
            commandSource.sendFeedback("You must be a player to tpa.");
            return;
        }
        if (parameters.length > 1) {
            class_69 target;
            class_73 world = ServerUtil.getServer().method_2157(0);
            if (parameters[1].equals("accept")) {
                for (int i = Tpa.requests.size() - 1; i >= 0; --i) {
                    Tpa.Request request = Tpa.requests.get(i);
                    if (!request.to.equals(player.field_528)) continue;
                    if (world.method_256() - request.time > 2400L) {
                        commandSource.sendFeedback("This tpa request has expired");
                        Tpa.requests.remove(request);
                        return;
                    }
                    class_69 from = ServerUtil.getConnectionManager().method_586(request.from);
                    if (from != null) {
                        ServerUtil.teleportPlayerToPlayer(commandSource, request.from, request.to);
                    } else {
                        commandSource.sendFeedback(request.from + " is no longer online.");
                    }
                    return;
                }
            }
            if ((target = ServerUtil.getConnectionManager().method_586(parameters[1])) == null) {
                commandSource.sendFeedback("Can't find user " + parameters[1] + ". No tpa.");
                return;
            }
            target.method_490("\u00a77" + player.field_528 + " wants to tp to you.");
            target.method_490("\u00a77type \"/tpa accept\" to allow them to. (expires in 2 min)");
            Tpa.requests.add(new Tpa.Request(player.field_528, target.field_528, world.method_256()));
        } else {
            commandSource.sendFeedback("You must have a target to tpa to.");
        }
    }
}

