/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retrocommands.mixin;

import com.matthewperiut.retrocommands.RetroCommands;
import com.matthewperiut.retrocommands.api.Command;
import com.matthewperiut.retrocommands.optionaldep.mojangfix.MJFChatAccess;
import com.matthewperiut.retrocommands.util.RetroChatUtil;
import com.matthewperiut.retrocommands.util.SharedCommandSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_211;
import net.minecraft.class_32;
import net.minecraft.class_40;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_211.class}, priority=1100)
public abstract class ChatScreenMixin
extends class_32 {
    @Shadow
    protected String field_786;
    @Shadow
    private int field_787;
    @Unique
    private boolean autocomplete = false;
    @Unique
    private String[] suggestions = new String[0];
    @Unique
    private int chosen = 0;
    @Unique
    private int textWidthPixels = 0;
    @Unique
    private int textWidthPixelsBeforeCurrentWord = 0;
    @Unique
    private String currentWord = "";
    private static final List<String> list = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add("me");
            this.add("kill");
            this.add("tell");
        }
    });

    @Unique
    void setText(String s) {
        if (RetroCommands.mjf) {
            MJFChatAccess.setText(s);
        }
        if (this.field_786 != null) {
            this.field_786 = s;
        }
    }

    @Unique
    String getText() {
        String result = RetroCommands.mjf ? MJFChatAccess.getText() : this.field_786;
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Unique
    void appendText(String s) {
        this.setText(this.field_786 + s);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressedInit(char i, int par2, CallbackInfo ci) {
        if (par2 == 15 && this.suggestions.length > 0) {
            this.autocomplete = true;
        }
        if (this.suggestions.length > 1 && this.adjustChosenSuggestion(par2)) {
            ci.cancel();
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="TAIL")})
    private void processInput(char i, int par2, CallbackInfo ci) {
        this.resetValues();
        if (this.getText().isEmpty()) {
            return;
        }
        String[] sections = this.getText().split(" ");
        if (sections.length == 0) {
            return;
        }
        this.currentWord = sections[sections.length - 1];
        this.fetchSuggestionsForCurrentWord(sections);
        if (this.getText().endsWith(" ")) {
            this.currentWord = "";
        }
        if (this.suggestions.length > 1) {
            this.calculateTextWidthPixelsBeforeCurrentWord(sections);
        }
    }

    private void resetValues() {
        this.currentWord = "";
        this.suggestions = new String[0];
    }

    private void fetchSuggestionsForCurrentWord(String[] sections) {
        try {
            Minecraft mc = (Minecraft)FabricLoader.getInstance().getGameInstance();
            if (this.getText().startsWith(" ")) {
                return;
            }
            if (sections.length == 1 && this.currentWord.length() > 1 && this.getText().charAt(0) == '/' && !this.getText().endsWith(" ")) {
                this.suggestions = mc.field_2804.field_180 && !RetroCommands.mp_spc ? (String[])list.stream().filter(s -> s.startsWith(this.currentWord.substring(1))).map(s -> s.substring(this.getText().length() - 1)).toArray(String[]::new) : (String[])RetroChatUtil.commands.stream().filter(c -> c.name().startsWith(this.currentWord.substring(1))).filter(c -> !c.disableInSingleplayer() || mc.field_2804.field_180).filter(c -> RetroCommands.mp_op || !c.needsPermissions() || !mc.field_2804.field_180).map(c -> c.name().substring(this.getText().length() - 1)).toArray(String[]::new);
            } else {
                Command command = RetroChatUtil.commands.stream().filter(c -> c.name().equals(sections[0].substring(1))).filter(c -> !c.disableInSingleplayer() || mc.field_2804.field_180).filter(c -> RetroCommands.mp_op || !c.needsPermissions() || !mc.field_2804.field_180).findFirst().orElse(null);
                if (command != null && (!command.disableInSingleplayer() || mc.field_2804.field_180)) {
                    class_40 player = mc.field_2806;
                    SharedCommandSource source = new SharedCommandSource(player);
                    this.suggestions = this.getText().endsWith(" ") ? command.suggestion(source, sections.length, "", this.getText()) : command.suggestion(source, sections.length - 1, this.currentWord, this.getText());
                }
            }
            this.textWidthPixels = this.field_156.method_1901("> " + this.getText());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private boolean adjustChosenSuggestion(int par2) {
        int initial = this.chosen++;
        if (par2 == 200) {
            // empty if block
        }
        if (par2 == 208) {
            --this.chosen;
        }
        if (this.chosen < 0) {
            this.chosen = this.suggestions.length - 1;
        }
        if (this.chosen >= this.suggestions.length) {
            this.chosen = 0;
        }
        return initial != this.chosen;
    }

    private void calculateTextWidthPixelsBeforeCurrentWord(String[] sections) {
        for (int j = 0; j < sections.length - 1; ++j) {
            this.textWidthPixelsBeforeCurrentWord += this.field_156.method_1901(sections[j] + " ");
        }
    }

    @Unique
    boolean tryMatch(String s) {
        try {
            AtomicBoolean valid = new AtomicBoolean(false);
            RetroChatUtil.commands.stream().forEach(a -> {
                if (a.name().equals(s)) {
                    if (!this.field_151.field_2804.field_180) {
                        valid.set(true);
                    } else if (RetroCommands.mp_op) {
                        valid.set(true);
                    } else if (!a.needsPermissions()) {
                        valid.set(true);
                    }
                }
            });
            if (valid.get()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void replace(int i, int j, float f, CallbackInfo ci) {
        boolean caretVisible;
        this.method_1932(2, this.field_153 - 14, this.field_152 - 2, this.field_153 - 2, Integer.MIN_VALUE);
        this.renderSuggestions(i, j, f);
        Object alreadyRendered = "";
        alreadyRendered = (String)alreadyRendered + "> ";
        if (this.getText().startsWith("/") && !this.getText().contains(" ") && !this.tryMatch(this.getText().substring(1))) {
            alreadyRendered = (String)alreadyRendered + "/";
            alreadyRendered = (String)alreadyRendered + this.getText().substring(1);
        } else if (this.getText().startsWith("/")) {
            if (!this.tryMatch(this.getText().split(" ")[0].substring(1))) {
                // empty if block
            }
            alreadyRendered = (String)alreadyRendered + this.getText();
        } else {
            alreadyRendered = (String)alreadyRendered + this.getText();
        }
        boolean bl = caretVisible = this.field_787 / 6 % 2 == 0;
        if (RetroCommands.mjf) {
            int cursorPosition = MJFChatAccess.getCursorPosition();
            alreadyRendered = new StringBuilder((String)alreadyRendered).insert(((String)alreadyRendered).length() + cursorPosition, caretVisible ? "_" : "").toString();
        } else {
            alreadyRendered = (String)alreadyRendered + (caretVisible ? "_" : "");
        }
        this.method_1937(this.field_156, (String)alreadyRendered, 4, this.field_153 - 12, 0xE0E0E0);
        super.method_118(i, j, f);
        ci.cancel();
    }

    public void renderSuggestions(int j, int f, float par3) {
        try {
            if (this.suggestions.length > 0) {
                this.ensureChosenIsInRange();
                this.renderChosenSuggestion();
                if (this.suggestions.length > 1) {
                    this.renderMultipleSuggestions();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Unique
    private void ensureChosenIsInRange() {
        if (this.chosen < 0 || this.chosen >= this.suggestions.length) {
            this.chosen = 0;
        }
    }

    private void renderChosenSuggestion() {
        this.method_1937(this.field_156, this.suggestions[this.chosen], 4 + this.textWidthPixels, this.field_153 - 12, 0xAAAAAA);
        if (this.autocomplete) {
            this.appendText(this.suggestions[this.chosen]);
            this.autocomplete = false;
            this.suggestions = new String[0];
        }
    }

    private void renderMultipleSuggestions() {
        int textWidthCurrentWord = this.field_156.method_1901(this.currentWord);
        this.textWidthPixelsBeforeCurrentWord = this.field_156.method_1901("> " + this.getText()) - textWidthCurrentWord;
        this.method_1932(this.textWidthPixelsBeforeCurrentWord + 4, this.field_153 - 14 - 10 * this.suggestions.length, this.textWidthPixelsBeforeCurrentWord + textWidthCurrentWord + this.getMaxSuggestionWidth() + 4, this.field_153 - 14, -16777216);
        for (int i = 0; i < this.suggestions.length; ++i) {
            this.method_1937(this.field_156, this.currentWord + this.suggestions[i], this.textWidthPixelsBeforeCurrentWord + 4, this.field_153 - 12 - 10 * (i + 1), i == this.chosen ? 0xFCFC00 : 0xFFFFFF);
        }
    }

    private int getMaxSuggestionWidth() {
        int maxWidth = 0;
        for (String suggestion : this.suggestions) {
            int width = this.field_156.method_1901(suggestion);
            if (maxWidth >= width) continue;
            maxWidth = width;
        }
        return maxWidth;
    }
}

