/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.commandapi.wrappers;

import java.util.Objects;

public class IntegerRange {
    private final int low;
    private final int high;

    public IntegerRange(int low, int high) {
        this.low = low;
        this.high = high;
    }

    public static IntegerRange integerRangeGreaterThanOrEq(int min) {
        return new IntegerRange(min, Integer.MAX_VALUE);
    }

    public static IntegerRange integerRangeLessThanOrEq(int max) {
        return new IntegerRange(Integer.MIN_VALUE, max);
    }

    public int getLowerBound() {
        return this.low;
    }

    public int getUpperBound() {
        return this.high;
    }

    public boolean isInRange(int i) {
        return i >= this.low && i <= this.high;
    }

    public String toString() {
        if (this.high == Integer.MAX_VALUE) {
            return this.low + "..";
        }
        if (this.low == Integer.MIN_VALUE) {
            return ".." + this.high;
        }
        return this.low + ".." + this.high;
    }

    public int hashCode() {
        return Objects.hash(this.high, this.low);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntegerRange)) {
            return false;
        }
        IntegerRange other = (IntegerRange)obj;
        return this.high == other.high && this.low == other.low;
    }
}

