/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.paper;

import dev.consti.commandbridge.commandapi.CommandAPI;
import dev.consti.commandbridge.commandapi.CommandAPIBukkitConfig;
import dev.consti.commandbridge.paper.core.Runtime;
import dev.consti.foundationlib.logging.Logger;
import java.io.InputStream;
import java.util.Properties;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static Main instance;
    private final Logger logger;

    public Main() {
        instance = this;
        this.logger = Runtime.getInstance().getLogger();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        try (InputStream input = Main.class.getClassLoader().getResourceAsStream("plugin.properties");){
            if (input == null) {
                String string2 = "Unknown";
                return string2;
            }
            Properties properties = new Properties();
            properties.load(input);
            String string = properties.getProperty("plugin.version", "Unknown");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Unknown";
        }
    }

    public static Main getInstance() {
        return instance;
    }

    public void onLoad() {
        CommandAPI.onLoad(((CommandAPIBukkitConfig)((CommandAPIBukkitConfig)new CommandAPIBukkitConfig(this).verboseOutput(false)).silentLogs(true)).skipReloadDatapacks(true).shouldHookPaperReload(false));
    }

    public void onEnable() {
        CommandAPI.onEnable();
        this.logger.info("Initializing CommandBridge...", new Object[0]);
        Runtime.getInstance().getStartup().start();
    }

    public void onDisable() {
        CommandAPI.onDisable();
        this.logger.info("Stopping CommandBridge...", new Object[0]);
        Runtime.getInstance().getStartup().stop();
    }
}

