/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.paper.command;

import dev.consti.commandbridge.paper.Main;
import dev.consti.commandbridge.paper.core.Runtime;
import dev.consti.commandbridge.paper.utils.CommandUtils;
import dev.consti.commandbridge.paper.utils.SchedulerAdapter;
import dev.consti.foundationlib.json.MessageParser;
import dev.consti.foundationlib.logging.Logger;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandExecutor {
    private final Main plugin = Main.getInstance();
    private final Logger logger = Runtime.getInstance().getLogger();

    public void dispatchCommand(String message) {
        MessageParser parser = new MessageParser(message);
        String serverId = Runtime.getInstance().getConfig().getKey("config.yml", "client-id");
        if (!parser.getBodyValueAsString("client").equals(serverId)) {
            this.logger.debug("Message not intended for this client: {}", serverId);
            return;
        }
        String command = parser.getBodyValueAsString("command");
        String target = parser.getBodyValueAsString("target");
        this.logger.info("Dispatching command '{}' for executor: {}", command, target);
        switch (target) {
            case "console": {
                this.executeConsoleCommand(command);
                break;
            }
            case "player": {
                this.executePlayerCommand(parser, command);
                break;
            }
            default: {
                this.logger.warn("Invalid target: {}", target);
            }
        }
    }

    private void executeConsoleCommand(String command) {
        this.logger.debug("Executing command '{}' as console", command);
        if (CommandUtils.isCommandValid(command)) {
            this.logger.warn("Invalid command: {}", command);
            Runtime.getInstance().getClient().sendError("Invalid command: " + command);
            return;
        }
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        new SchedulerAdapter(this.plugin).run(() -> this.lambda$executeConsoleCommand$0((CommandSender)console, command));
    }

    private void executePlayerCommand(MessageParser parser, String command) {
        this.logger.debug("Executing command '{}' as player", command);
        String uuidStr = parser.getBodyValueAsString("uuid");
        String name = parser.getBodyValueAsString("name");
        try {
            UUID uuid = UUID.fromString(uuidStr);
            Optional<Player> playerOptional = Optional.ofNullable(Bukkit.getPlayer((UUID)uuid));
            playerOptional.ifPresentOrElse(player -> this.handlePlayerCommand((Player)player, command), () -> this.logger.warn("Player '{}' not found or offline", name));
        }
        catch (Exception e) {
            this.logger.error("Error while processing player: {}", this.logger.getDebug() != false ? e : e.getMessage());
            Runtime.getInstance().getClient().sendError("Error while processing player: " + e.getMessage());
        }
    }

    private void handlePlayerCommand(Player player, String command) {
        if (CommandUtils.isCommandValid(command)) {
            this.logger.warn("Invalid command: {}", command);
            Runtime.getInstance().getClient().sendError("Invalid command: " + command);
            player.sendMessage("\u00a7cThe command '" + command + "' is invalid");
            return;
        }
        new SchedulerAdapter(this.plugin).run(() -> {
            boolean status = Bukkit.dispatchCommand((CommandSender)player, (String)command);
            this.logResult("player", command, status);
        });
    }

    private void logResult(String target, String command, boolean status) {
        if (status) {
            this.logger.info("Successfully executed command '{}' as {}", command, target);
        } else {
            this.logger.warn("Failed to execute command '{}' as {}", command, target);
            Runtime.getInstance().getClient().sendError("Failed to execute command '" + command + "' as " + target);
        }
    }

    private /* synthetic */ void lambda$executeConsoleCommand$0(CommandSender console, String command) {
        boolean status = Bukkit.dispatchCommand((CommandSender)console, (String)command);
        this.logResult("console", command, status);
    }
}

