/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.paper.command;

import dev.consti.commandbridge.paper.Main;
import dev.consti.commandbridge.paper.core.Runtime;
import dev.consti.commandbridge.paper.utils.SchedulerAdapter;
import dev.consti.foundationlib.logging.Logger;
import dev.consti.foundationlib.utils.ScriptManager;
import dev.consti.foundationlib.utils.StringParser;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandForwarder {
    private final Logger logger;
    private final Main plugin;

    public CommandForwarder(Logger logger, Main plugin) {
        this.logger = logger;
        this.plugin = plugin;
    }

    public int executeScriptCommands(CommandSender sender, ScriptManager.ScriptConfig script, String[] args) {
        if (this.isPermissionDenied(sender, script)) {
            return 0;
        }
        block8: for (ScriptManager.Command cmd : script.getCommands()) {
            this.logger.debug("Processing command: {}", cmd.getCommand());
            switch (cmd.getTargetExecutor().toLowerCase()) {
                case "player": {
                    this.handlePlayerExecutor(cmd, sender, args);
                    continue block8;
                }
                case "console": {
                    this.handleConsoleExecutor(cmd, args);
                    continue block8;
                }
            }
            this.logger.warn("Unknown target executor for command: {}", cmd.getCommand());
        }
        return 1;
    }

    private boolean isPermissionDenied(CommandSender sender, ScriptManager.ScriptConfig script) {
        if (!script.shouldIgnorePermissionCheck() && !sender.hasPermission("commandbridge.command." + script.getName())) {
            this.logger.warn("Sender '{}' has no permission to use this command", sender);
            if (!script.shouldHidePermissionWarning()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            }
            return true;
        }
        return false;
    }

    private void handlePlayerExecutor(ScriptManager.Command cmd, CommandSender sender, String[] args) {
        if (cmd.isCheckIfExecutorIsPlayer() && !(sender instanceof Player)) {
            this.logger.warn("This command requires a player as executor, but sender is not a player.", new Object[0]);
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command requires a player as executor, but source is not a player object");
            return;
        }
        Player player = (Player)sender;
        String parsedCommand = this.parseCommand(cmd, args, player);
        if (parsedCommand == null) {
            return;
        }
        if (cmd.getDelay() > 0) {
            this.scheduleCommand(cmd, parsedCommand, player);
        } else {
            this.sendCommand(cmd, parsedCommand, player);
        }
    }

    private void handleConsoleExecutor(ScriptManager.Command cmd, String[] args) {
        String parsedCommand = this.parseCommand(cmd, args, null);
        if (parsedCommand == null) {
            return;
        }
        if (cmd.getDelay() > 0) {
            this.scheduleCommand(cmd, parsedCommand, null);
        } else {
            this.sendCommand(cmd, parsedCommand, null);
        }
    }

    private String parseCommand(ScriptManager.Command cmd, String[] args, Player player) {
        StringParser parser = StringParser.create();
        if (player == null || !cmd.getTargetExecutor().equals("player")) {
            return parser.parsePlaceholders(cmd.getCommand(), args);
        }
        this.addPlayerPlaceholders(parser, player);
        try {
            String parsedCommand = parser.parsePlaceholders(cmd.getCommand(), args);
            if (Runtime.getInstance().getStartup().isPlaceholderAPI()) {
                parsedCommand = PlaceholderAPI.setPlaceholders((Player)player, (String)parsedCommand);
            }
            return parsedCommand;
        }
        catch (Exception e) {
            this.logger.error("Error occurred while parsing command: {}", this.logger.getDebug() != false ? e : e.getMessage());
            if (player != null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Error occurred while parsing command");
            }
            Runtime.getInstance().getClient().sendError("Error occurred while parsing commands");
            return null;
        }
    }

    private void addPlayerPlaceholders(StringParser parser, Player player) {
        this.logger.debug("Adding placeholders for player: {}", player.getName());
        parser.addPlaceholder("%cb_player%", player.getName());
        parser.addPlaceholder("%cb_uuid%", player.getUniqueId().toString());
        parser.addPlaceholder("%cb_world%", player.getWorld().getName());
    }

    private void scheduleCommand(ScriptManager.Command cmd, String command, Player player) {
        this.logger.debug("Scheduling command '{}' with delay: {} seconds", cmd.getCommand(), cmd.getDelay());
        if (player != null) {
            player.sendMessage("Scheduling command with '" + cmd.getDelay() + "' seconds");
        }
        new SchedulerAdapter(this.plugin).runLater(() -> this.sendCommand(cmd, command, player), (long)cmd.getDelay() * 20L);
    }

    private void sendCommand(ScriptManager.Command cmd, String command, Player player) {
        this.logger.info("Sending command to server as {}", player == null ? "console" : "player");
        Runtime.getInstance().getClient().sendCommand(command, "", cmd.getTargetExecutor(), player);
    }
}

