/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.paper.command;

import dev.consti.commandbridge.commandapi.CommandAPI;
import dev.consti.commandbridge.commandapi.CommandAPICommand;
import dev.consti.commandbridge.commandapi.arguments.Argument;
import dev.consti.commandbridge.commandapi.arguments.GreedyStringArgument;
import dev.consti.commandbridge.commandapi.executors.ExecutorType;
import dev.consti.commandbridge.paper.command.CommandForwarder;
import dev.consti.commandbridge.paper.core.Runtime;
import dev.consti.foundationlib.logging.Logger;
import dev.consti.foundationlib.utils.ScriptManager;
import java.util.ArrayList;
import java.util.List;

public class CommandRegistrar {
    private final Logger logger;
    private final CommandForwarder forwarder;
    private final List<String> registeredCommands = new ArrayList<String>();

    public CommandRegistrar(Logger logger) {
        this.logger = logger;
        this.forwarder = Runtime.getInstance().getForwarder();
    }

    public void unregisterAllCommands() {
        for (String command : this.registeredCommands) {
            try {
                CommandAPI.unregister(command);
                this.logger.debug("Unregistered command: {}", command);
            }
            catch (Exception e) {
                this.logger.error("Failed to unregister command '{}' : {}", command, this.logger.getDebug() != false ? e : e.getMessage());
            }
        }
        this.registeredCommands.clear();
        this.logger.info("All registered commands have been unregistered.", new Object[0]);
    }

    public void registerCommand(ScriptManager.ScriptConfig script) {
        String commandName = script.getName();
        try {
            CommandAPICommand command = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand(commandName).withOptionalArguments(new Argument[]{new GreedyStringArgument("args")})).executes((sender, args) -> {
                String argsString = (String)args.get("args");
                this.logger.debug("Command '{}' called with arguments: {}", commandName, argsString);
                String[] splitArgs = argsString != null ? argsString.split(" ") : new String[]{};
                return this.forwarder.executeScriptCommands(sender, script, splitArgs);
            }, new ExecutorType[0]);
            command.register();
            this.registeredCommands.add(commandName);
        }
        catch (Exception e) {
            this.logger.error("Failed to register command '{}' : {}", commandName, this.logger.getDebug() != false ? e : e.getMessage());
        }
    }
}

