/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.paper.core;

import dev.consti.commandbridge.paper.Main;
import dev.consti.commandbridge.paper.command.CommandExecutor;
import dev.consti.commandbridge.paper.command.CommandForwarder;
import dev.consti.commandbridge.paper.command.CommandRegistrar;
import dev.consti.commandbridge.paper.core.Startup;
import dev.consti.commandbridge.paper.utils.GeneralUtils;
import dev.consti.commandbridge.paper.utils.ScriptUtils;
import dev.consti.commandbridge.paper.websocket.Client;
import dev.consti.foundationlib.logging.Logger;
import dev.consti.foundationlib.utils.ConfigManager;

public class Runtime {
    private static Runtime instance;
    private Logger logger;
    private ConfigManager config;
    private ScriptUtils scriptUtils;
    private Client client;
    private Startup startup;
    private CommandForwarder forwarder;
    private CommandRegistrar registrar;
    private GeneralUtils generalUtils;
    private CommandExecutor commandExecutor;

    private Runtime() {
    }

    public static synchronized Runtime getInstance() {
        if (instance == null) {
            instance = new Runtime();
            instance.getLogger().debug("Runtime singleton instance initialized.", new Object[0]);
        }
        return instance;
    }

    public synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger("CommandBridge");
            this.logger.debug("Logger initialized.", new Object[0]);
        }
        return this.logger;
    }

    public synchronized ConfigManager getConfig() {
        if (this.config == null) {
            this.config = new ConfigManager(this.getLogger(), "CommandBridge");
            this.getLogger().debug("ConfigManager initialized.", new Object[0]);
        }
        return this.config;
    }

    public synchronized ScriptUtils getScriptUtils() {
        if (this.scriptUtils == null) {
            this.scriptUtils = new ScriptUtils(this.getLogger(), "CommandBridge");
            this.getLogger().debug("ScriptUtils initialized.", new Object[0]);
        }
        return this.scriptUtils;
    }

    public synchronized Client getClient() {
        if (this.client == null) {
            this.client = new Client(this.getLogger(), this.getConfig().getKey("config.yml", "secret"));
            this.getLogger().debug("Server initialized.", new Object[0]);
        }
        return this.client;
    }

    public synchronized Startup getStartup() {
        if (this.startup == null) {
            this.startup = new Startup(this.getLogger());
            this.getLogger().debug("Startup initialized.", new Object[0]);
        }
        return this.startup;
    }

    public synchronized CommandForwarder getForwarder() {
        if (this.forwarder == null) {
            this.forwarder = new CommandForwarder(this.getLogger(), Main.getInstance());
            this.getLogger().debug("CommandHelper initialized.", new Object[0]);
        }
        return this.forwarder;
    }

    public synchronized CommandRegistrar getRegistrar() {
        if (this.registrar == null) {
            this.registrar = new CommandRegistrar(this.getLogger());
            this.getLogger().debug("CommandRegistrar initialized.", new Object[0]);
        }
        return this.registrar;
    }

    public synchronized GeneralUtils getGeneralUtils() {
        if (this.generalUtils == null) {
            this.generalUtils = new GeneralUtils(this.getLogger());
            this.getLogger().debug("GeneralUtils initialized.", new Object[0]);
        }
        return this.generalUtils;
    }

    public synchronized CommandExecutor getCommandExecutor() {
        if (this.commandExecutor == null) {
            this.commandExecutor = new CommandExecutor();
            this.getLogger().debug("CommandExecutor initialized.", new Object[0]);
        }
        return this.commandExecutor;
    }
}

