/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.paper.core;

import dev.consti.commandbridge.paper.Main;
import dev.consti.commandbridge.paper.core.Runtime;
import dev.consti.commandbridge.paper.utils.SchedulerAdapter;
import dev.consti.foundationlib.logging.Logger;
import dev.consti.foundationlib.utils.VersionChecker;
import org.bukkit.Bukkit;

public class Startup {
    private final Logger logger;
    private final Runtime runtime;
    private boolean placeholderAPI = false;

    public Startup(Logger logger) {
        this.logger = logger;
        this.runtime = Runtime.getInstance();
    }

    public void start() {
        try {
            this.runtime.getConfig().copyConfig("bukkit-config.yml", "config.yml");
            this.runtime.getConfig().loadAllConfigs();
            boolean debugMode = Boolean.parseBoolean(this.runtime.getConfig().getKey("config.yml", "debug"));
            this.logger.setDebug(debugMode);
            if (SchedulerAdapter.isFolia()) {
                this.logger.info("Running on Folia!", new Object[0]);
            }
            this.logger.info("Debug mode set to: {}", debugMode);
            this.logger.debug("Copying default scripts...", new Object[0]);
            this.runtime.getScriptUtils().copyDefaultScript("bukkit-example.yml", "example.yml");
            this.runtime.getScriptUtils().loadAllScripts();
            this.logger.debug("Connecting to WebSocket server...", new Object[0]);
            this.runtime.getClient().connect(this.runtime.getConfig().getKey("config.yml", "remote"), Integer.parseInt(this.runtime.getConfig().getKey("config.yml", "port")));
            this.logger.debug("Setting up version checker...", new Object[0]);
            VersionChecker.setProjectId("wIuI4ru2");
            this.logger.debug("Checking for updates...", new Object[0]);
            this.checkForUpdates();
            this.logger.debug("Registering internal commands...", new Object[0]);
            this.runtime.getGeneralUtils().registerCommands();
            if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                this.logger.info("Hooked into PlaceholderAPI \u2014 external placeholders enabled", new Object[0]);
                this.placeholderAPI = true;
            } else {
                this.logger.warn("PlaceholderAPI not found \u2014 using internal placeholder system only", new Object[0]);
                this.placeholderAPI = false;
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize CommandBridge: {}", this.logger.getDebug() != false ? e : e.getMessage());
        }
    }

    public boolean isPlaceholderAPI() {
        return this.placeholderAPI;
    }

    public void stop() {
        try {
            this.logger.debug("Disconnecting from WebSocket server...", new Object[0]);
            this.runtime.getClient().disconnect();
        }
        catch (Exception e) {
            this.logger.error("Failed to stop CommandBridge: {}", this.logger.getDebug() != false ? e : e.getMessage());
        }
    }

    private void checkForUpdates() {
        String currentVersion = Main.getVersion();
        this.logger.debug("Current version: {}", currentVersion);
        new Thread(() -> {
            try {
                String latestVersion = VersionChecker.getLatestVersion();
                if (latestVersion == null) {
                    this.logger.warn("Unable to check for updates", new Object[0]);
                    return;
                }
                if (VersionChecker.isNewerVersion(latestVersion, currentVersion)) {
                    this.logger.warn("A new version is available: {}", latestVersion);
                    this.logger.warn("Please download the latest release: {}", VersionChecker.getDownloadUrl());
                    this.runtime.getClient().sendError("Please update CommandBridge");
                } else {
                    this.logger.info("You are running the latest version: {}", currentVersion);
                }
            }
            catch (Exception e) {
                this.logger.error("Error while checking for updates: {}", this.logger.getDebug() != false ? e : e.getMessage());
            }
        }).start();
    }
}

