/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.paper.utils;

import dev.consti.commandbridge.commandapi.CommandAPICommand;
import dev.consti.commandbridge.commandapi.arguments.Argument;
import dev.consti.commandbridge.commandapi.arguments.ArgumentSuggestions;
import dev.consti.commandbridge.commandapi.arguments.StringArgument;
import dev.consti.commandbridge.commandapi.executors.ExecutorType;
import dev.consti.commandbridge.paper.Main;
import dev.consti.commandbridge.paper.core.Runtime;
import dev.consti.commandbridge.paper.utils.SchedulerAdapter;
import dev.consti.foundationlib.logging.Logger;
import java.util.ArrayList;
import org.bukkit.ChatColor;

public class GeneralUtils {
    private final Logger logger;

    public GeneralUtils(Logger logger) {
        this.logger = logger;
    }

    public void reloadAll() {
        new SchedulerAdapter(Main.getInstance()).run(() -> {
            this.logger.debug("Running on thread (reload): {}", Thread.currentThread().getName());
            try {
                Runtime.getInstance().getConfig().reload();
                this.logger.debug("All configs have been reloaded", new Object[0]);
                this.logger.setDebug(Boolean.parseBoolean(Runtime.getInstance().getConfig().getKey("config.yml", "debug")));
                this.logger.info("Debug mode set to: {}", Runtime.getInstance().getConfig().getKey("config.yml", "debug"));
                Runtime.getInstance().getScriptUtils().reload();
                this.logger.debug("All scripts have been reloaded", new Object[0]);
                this.logger.info("Everything Reloaded!", new Object[0]);
                Runtime.getInstance().getClient().sendTask("reload", "success");
            }
            catch (Exception e) {
                this.logger.error("Error occurred while reloading: {}", this.logger.getDebug() != false ? e : e.getMessage());
                Runtime.getInstance().getClient().sendTask("reload", "failure");
            }
        });
    }

    public void registerCommands() {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        arguments.add((Argument)new StringArgument("arguments").replaceSuggestions(ArgumentSuggestions.strings("reconnect")));
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("commandbridgeclient").withArguments(arguments)).withAliases("cbc")).withPermission("commandbridge.admin")).executes((sender, args) -> {
            String opt = (String)args.get("arguments");
            if (opt.matches("reconnect")) {
                Runtime.getInstance().getClient().disconnect();
                try {
                    Runtime.getInstance().getClient().connect(Runtime.getInstance().getConfig().getKey("config.yml", "remote"), Integer.parseInt(Runtime.getInstance().getConfig().getKey("config.yml", "port")));
                }
                catch (Exception e) {
                    this.logger.error("Client reconnection failed: ", e);
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to reconnect");
                }
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Client reconnected successfully");
            }
        }, new ExecutorType[0])).register();
    }
}

