/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.paper.utils;

import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SchedulerAdapter {
    private final JavaPlugin plugin;

    public SchedulerAdapter(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void run(Runnable task) {
        if (SchedulerAdapter.isFolia()) {
            Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin, task);
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, task);
        }
    }

    public void runLater(Runnable task, long delayTicks) {
        if (SchedulerAdapter.isFolia()) {
            Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, (Consumer)((Object)task), delayTicks);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, task, delayTicks);
        }
    }

    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

