/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.paper.utils;

import dev.consti.commandbridge.paper.Main;
import dev.consti.commandbridge.paper.command.CommandRegistrar;
import dev.consti.commandbridge.paper.core.Runtime;
import dev.consti.commandbridge.paper.utils.SchedulerAdapter;
import dev.consti.foundationlib.logging.Logger;
import dev.consti.foundationlib.utils.ScriptManager;

public class ScriptUtils
extends ScriptManager {
    private final Logger logger;
    private final CommandRegistrar registrar;

    public ScriptUtils(Logger logger, String pluginName) {
        super(logger, pluginName);
        this.logger = logger;
        this.registrar = Runtime.getInstance().getRegistrar();
    }

    @Override
    public void onFileProcessed(String fileName, ScriptManager.ScriptConfig scriptConfig) {
        if (scriptConfig.isEnabled()) {
            this.logger.info("Loaded script: {}", fileName);
            try {
                this.registrar.registerCommand(this.getScriptConfig(fileName));
                this.logger.debug("Registered command: {}", scriptConfig.getName());
            }
            catch (Exception e) {
                this.logger.error("Failed to register script '{}' : {}", scriptConfig.getName(), this.logger.getDebug() != false ? e : e.getMessage());
            }
        } else {
            this.logger.info("Skipped disabled script: {}", scriptConfig.getName());
        }
    }

    public void unloadCommands(Runnable callback) {
        new SchedulerAdapter(Main.getInstance()).run(() -> {
            this.logger.debug("Running on thread (unload): {}", Thread.currentThread().getName());
            Runtime.getInstance().getRegistrar().unregisterAllCommands();
            this.logger.debug("All commands have been unloaded", new Object[0]);
            callback.run();
        });
    }
}

