/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.consti.commandbridge.bstats.velocity.Metrics;
import dev.consti.commandbridge.velocity.core.Runtime;
import dev.consti.commandbridge.velocity.util.ProxyUtils;
import dev.consti.foundationlib.logging.Logger;
import dev.consti.foundationlib.utils.VersionChecker;
import java.io.InputStream;
import java.util.Properties;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

@Plugin(id="commandbridge", name="CommandBridge", version="Unknown", authors={"objz"})
public class Main {
    private static Main instance;
    public final ProxyServer proxy;
    private final Logger logger;
    private final Metrics.Factory metricsFactory;

    @Inject
    public Main(ProxyServer proxy, Logger bLogger, Metrics.Factory metricsFactory) {
        this.proxy = proxy;
        this.logger = Runtime.getInstance().getLogger();
        instance = this;
        this.metricsFactory = metricsFactory;
        ProxyUtils.setProxyServer(proxy);
    }

    public static Main getInstance() {
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        try (InputStream input = Main.class.getClassLoader().getResourceAsStream("plugin.properties");){
            if (input == null) {
                String string2 = "Unknown";
                return string2;
            }
            Properties properties = new Properties();
            properties.load(input);
            String string = properties.getProperty("plugin.version", "Unknown");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Unknown";
        }
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.logger.info("Initializing CommandBridge...", new Object[0]);
        Runtime.getInstance().getStartup().start();
        int pluginId = 22008;
        this.metricsFactory.make(this, pluginId);
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.logger.info("Stopping CommandBridge...", new Object[0]);
        Runtime.getInstance().getStartup().stop();
    }

    @Subscribe
    public void onPlayerJoin(PostLoginEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            this.logger.warn("PostLoginEvent triggered with a null player object.", new Object[0]);
            return;
        }
        if (player.hasPermission("commandbridge.admin")) {
            this.logger.debug("Player '{}' has admin permissions. Checking for updates...", player.getUsername());
            this.proxy.getScheduler().buildTask((Object)this, () -> {
                String currentVersion = Main.getVersion();
                String latestVersion = VersionChecker.getLatestVersion();
                if (latestVersion == null) {
                    player.sendMessage(Component.text((String)"Unable to check for updates.").color((TextColor)NamedTextColor.RED));
                    this.logger.warn("Update check failed: Unable to retrieve the latest version.", new Object[0]);
                    return;
                }
                if (VersionChecker.isNewerVersion(latestVersion, currentVersion)) {
                    player.sendMessage(Component.text((String)("A new version of CommandBridge is available: " + latestVersion)).color((TextColor)NamedTextColor.RED));
                    player.sendMessage(Component.text((String)"Please download the latest release: ").append(((TextComponent)((TextComponent)Component.text((String)"here").color((TextColor)NamedTextColor.BLUE)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.openUrl((String)VersionChecker.getDownloadUrl()))));
                    this.logger.debug("Notified player '{}' about the new version: {}", player.getUsername(), latestVersion);
                } else {
                    this.logger.debug("Player '{}' is running the latest version: {}", player.getUsername(), currentVersion);
                }
            }).schedule();
        } else {
            this.logger.debug("Player {} does not have admin permissions. No update check performed.", player.getUsername());
        }
    }
}

