/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.velocity.command;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.consti.commandbridge.velocity.Main;
import dev.consti.commandbridge.velocity.core.Runtime;
import dev.consti.commandbridge.velocity.util.ProxyUtils;
import dev.consti.foundationlib.logging.Logger;
import dev.consti.foundationlib.utils.ScriptManager;
import dev.consti.foundationlib.utils.StringParser;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.william278.papiproxybridge.api.PlaceholderAPI;

public class CommandForwarder {
    private final Logger logger;
    private final ProxyServer proxy;
    private final Main plugin;

    public CommandForwarder(Logger logger, Main plugin) {
        this.logger = logger;
        this.proxy = ProxyUtils.getProxyServer();
        this.plugin = plugin;
    }

    public int executeScriptCommands(CommandSource source, ScriptManager.ScriptConfig script, String[] args) {
        this.logger.debug("Executing script commands for script: {}", script.getName());
        if (this.isPermissionDenied(source, script)) {
            return 0;
        }
        block8: for (ScriptManager.Command cmd : script.getCommands()) {
            this.logger.debug("Processing command: {}", cmd.getCommand());
            switch (cmd.getTargetExecutor().toLowerCase()) {
                case "player": {
                    this.handlePlayerExecutor(cmd, source, args);
                    continue block8;
                }
                case "console": {
                    this.handleConsoleExecutor(cmd, source, args);
                    continue block8;
                }
            }
            this.logger.warn("Unknown target executor for command: {}", cmd.getCommand());
        }
        this.logger.info("Script commands executed successfully for command: {}", script.getName());
        return 1;
    }

    private boolean isPermissionDenied(CommandSource source, ScriptManager.ScriptConfig script) {
        if (!script.shouldIgnorePermissionCheck() && !source.hasPermission("commandbridge.command." + script.getName())) {
            this.logger.warn("Sender '{}' has no permission to use this command", source);
            if (!script.shouldHidePermissionWarning()) {
                source.sendMessage((Component)Component.text((String)"You do not have permission to use this command", (TextColor)NamedTextColor.RED));
            }
            return true;
        }
        return false;
    }

    private void handlePlayerExecutor(ScriptManager.Command cmd, CommandSource source, String[] args) {
        if (cmd.isCheckIfExecutorIsPlayer() && !(source instanceof Player)) {
            this.logger.warn("This command requires a player as executor, but source is not a player", new Object[0]);
            source.sendMessage((Component)Component.text((String)"This command requires a player as executor, but source is not a player object", (TextColor)NamedTextColor.RED));
            return;
        }
        Player player = (Player)source;
        if (cmd.isCheckIfExecutorIsOnServer() && !this.isPlayerOnTargetServer(player, cmd)) {
            this.logger.warn("Player '{}' is not on the required server for this command.", player.getUsername());
            source.sendMessage((Component)Component.text((String)("Player " + player.getUsername() + " is not on the required server"), (TextColor)NamedTextColor.YELLOW));
            return;
        }
        this.parseCommand(cmd, args, player).thenAccept(parsedCommand -> {
            if (parsedCommand == null) {
                return;
            }
            if (cmd.getDelay() > 0) {
                this.scheduleCommand(cmd, (String)parsedCommand, args, player, 0);
            } else {
                this.sendCommand(cmd, (String)parsedCommand, args, player, 0);
            }
        });
    }

    private void handleConsoleExecutor(ScriptManager.Command cmd, CommandSource source, String[] args) {
        this.parseCommand(cmd, args, null).thenAccept(parsedCommand -> {
            if (parsedCommand == null) {
                return;
            }
            if (cmd.getDelay() > 0) {
                this.scheduleCommand(cmd, (String)parsedCommand, args, null, 0);
            } else {
                this.sendCommand(cmd, (String)parsedCommand, args, null, 0);
            }
        });
    }

    private boolean isPlayerOnTargetServer(Player player, ScriptManager.Command cmd) {
        return player.getCurrentServer().map(serverConn -> cmd.getTargetClientIds().contains(serverConn.getServerInfo().getName())).orElse(false);
    }

    private CompletableFuture<String> parseCommand(ScriptManager.Command cmd, String[] args, Player player) {
        StringParser parser = StringParser.create();
        if (player == null || !cmd.getTargetExecutor().equals("player")) {
            return CompletableFuture.completedFuture(parser.parsePlaceholders(cmd.getCommand(), args));
        }
        this.addPlayerPlaceholders(parser, player);
        try {
            String parsedCommand = parser.parsePlaceholders(cmd.getCommand(), args);
            if (Runtime.getInstance().getStartup().isPlaceholderAPI()) {
                return PlaceholderAPI.createInstance().formatPlaceholders(parsedCommand, player.getUniqueId()).exceptionally(e -> {
                    this.logger.error("PlaceholderAPI error: {}", this.logger.getDebug() != false ? e : e.getMessage());
                    return parsedCommand;
                });
            }
            return CompletableFuture.completedFuture(parsedCommand);
        }
        catch (Exception e2) {
            this.logger.error("Error occurred while parsing command: {}", this.logger.getDebug() != false ? e2 : e2.getMessage());
            if (player != null) {
                player.sendMessage(Component.text((String)"Error occurred while parsing command").color((TextColor)NamedTextColor.RED));
            }
            for (String conn : cmd.getTargetClientIds()) {
                Runtime.getInstance().getServer().sendError(Runtime.getInstance().getServer().getWebSocket(conn), "Error occurred while parsing commands");
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    private void addPlayerPlaceholders(StringParser parser, Player player) {
        this.logger.debug("Adding placeholders for player: {}", player.getUsername());
        parser.addPlaceholder("%cb_player%", player.getUsername());
        parser.addPlaceholder("%cb_uuid%", player.getUniqueId().toString());
        parser.addPlaceholder("%cb_server%", player.getCurrentServer().map(srv -> srv.getServerInfo().getName()).orElse("defaultServerName"));
    }

    private void scheduleCommand(ScriptManager.Command cmd, String command, String[] args, Player player, int retryCount) {
        this.logger.debug("Scheduling command '{}' with delay: {} seconds", cmd.getCommand(), cmd.getDelay());
        this.proxy.getScheduler().buildTask((Object)this.plugin, () -> this.sendCommand(cmd, command, args, player, retryCount)).delay((long)cmd.getDelay(), TimeUnit.SECONDS).schedule();
    }

    private void sendCommand(ScriptManager.Command cmd, String command, String[] args, Player player, int retryCount) {
        this.logger.debug("Executing command: {} with retryCount: {}", cmd.getCommand(), retryCount);
        if (retryCount >= 30) {
            this.logger.warn("Max retries reached for command: {}", cmd.getCommand());
            if (player != null) {
                player.sendMessage((Component)Component.text((String)"Max retries reached", (TextColor)NamedTextColor.YELLOW));
            }
            return;
        }
        if (cmd.shouldWaitUntilPlayerIsOnline() && "player".equalsIgnoreCase(cmd.getTargetExecutor()) && (player == null || !player.isActive())) {
            this.logger.warn("Player is not online. Retrying command: {}", cmd.getCommand());
            player.sendMessage((Component)Component.text((String)"Player is not online. Retrying command", (TextColor)NamedTextColor.YELLOW));
            this.proxy.getScheduler().buildTask((Object)this.plugin, () -> this.sendCommand(cmd, command, args, player, retryCount + 1)).delay(1L, TimeUnit.SECONDS).schedule();
            return;
        }
        List<String> targetClients = cmd.getTargetClientIds();
        if (targetClients.isEmpty()) {
            this.logger.warn("No target clients defined for command: {}", cmd.getCommand());
            if (player != null) {
                player.sendMessage((Component)Component.text((String)"No target clients are defined for this command", (TextColor)NamedTextColor.RED));
            }
            return;
        }
        for (String clientId : targetClients) {
            if (Runtime.getInstance().getServer().isServerConnected(clientId)) {
                this.logger.info("Sending command to client '{}' as {}", clientId, player == null ? "console" : "player");
                Runtime.getInstance().getServer().sendCommand(command, clientId, cmd.getTargetExecutor(), player);
                continue;
            }
            this.logger.warn("Client '{}' not found", clientId);
            if (player == null) continue;
            player.sendMessage((Component)Component.text((String)("Client '" + clientId + "' not found"), (TextColor)NamedTextColor.RED));
        }
    }
}

