/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.velocity.core;

import dev.consti.commandbridge.velocity.Main;
import dev.consti.commandbridge.velocity.command.CommandDispatcher;
import dev.consti.commandbridge.velocity.command.CommandForwarder;
import dev.consti.commandbridge.velocity.command.CommandRegistrar;
import dev.consti.commandbridge.velocity.core.Startup;
import dev.consti.commandbridge.velocity.util.GeneralUtils;
import dev.consti.commandbridge.velocity.util.ScriptUtils;
import dev.consti.commandbridge.velocity.websocket.HttpServer;
import dev.consti.commandbridge.velocity.websocket.Server;
import dev.consti.foundationlib.logging.Logger;
import dev.consti.foundationlib.utils.ConfigManager;

public class Runtime {
    private static Runtime instance;
    private Logger logger;
    private ConfigManager config;
    private ScriptUtils scriptUtils;
    private Server server;
    private Startup startup;
    private CommandForwarder helper;
    private CommandRegistrar registrar;
    private GeneralUtils generalUtils;
    private CommandDispatcher commandDispatcher;
    private HttpServer httpServer;

    private Runtime() {
    }

    public static synchronized Runtime getInstance() {
        if (instance == null) {
            instance = new Runtime();
            instance.getLogger().debug("Runtime singleton instance initialized.", new Object[0]);
        }
        return instance;
    }

    public synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger("CommandBridge");
            this.logger.debug("Logger initialized.", new Object[0]);
        }
        return this.logger;
    }

    public synchronized ConfigManager getConfig() {
        if (this.config == null) {
            this.config = new ConfigManager(this.getLogger(), "CommandBridge");
            this.getLogger().debug("ConfigManager initialized.", new Object[0]);
        }
        return this.config;
    }

    public synchronized ScriptUtils getScriptUtils() {
        if (this.scriptUtils == null) {
            this.scriptUtils = new ScriptUtils(this.getLogger(), "CommandBridge");
            this.getLogger().debug("ScriptUtils initialized.", new Object[0]);
        }
        return this.scriptUtils;
    }

    public synchronized Server getServer() {
        if (this.server == null) {
            this.server = new Server(this.getLogger(), this.getConfig().getSecret());
            this.getLogger().debug("Server initialized.", new Object[0]);
        }
        return this.server;
    }

    public synchronized Startup getStartup() {
        if (this.startup == null) {
            this.startup = new Startup(this.getLogger());
            this.getLogger().debug("Startup initialized.", new Object[0]);
        }
        return this.startup;
    }

    public synchronized CommandForwarder getHelper() {
        if (this.helper == null) {
            this.helper = new CommandForwarder(this.getLogger(), Main.getInstance());
            this.getLogger().debug("CommandForwarder initialized.", new Object[0]);
        }
        return this.helper;
    }

    public synchronized CommandRegistrar getRegistrar() {
        if (this.registrar == null) {
            this.registrar = new CommandRegistrar(this.getLogger());
            this.getLogger().debug("InternalRegistrar initialized.", new Object[0]);
        }
        return this.registrar;
    }

    public synchronized GeneralUtils getGeneralUtils() {
        if (this.generalUtils == null) {
            this.generalUtils = new GeneralUtils(this.getLogger());
            this.getLogger().debug("GeneralUtils initialized.", new Object[0]);
        }
        return this.generalUtils;
    }

    public synchronized CommandDispatcher getCommandExecutor() {
        if (this.commandDispatcher == null) {
            this.commandDispatcher = new CommandDispatcher();
            this.getLogger().debug("CommandDispatcher initialized.", new Object[0]);
        }
        return this.commandDispatcher;
    }

    public synchronized HttpServer getHttpServer() {
        if (this.httpServer == null) {
            this.httpServer = new HttpServer(this.logger);
            this.getLogger().debug("HttpServer initialized.", new Object[0]);
        }
        return this.httpServer;
    }
}

