/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.velocity.core;

import dev.consti.commandbridge.velocity.Main;
import dev.consti.commandbridge.velocity.core.Runtime;
import dev.consti.commandbridge.velocity.websocket.Server;
import dev.consti.foundationlib.logging.Logger;
import dev.consti.foundationlib.utils.VersionChecker;

public class Startup {
    private final Logger logger;
    private final Runtime runtime;
    private boolean placeholderAPI = false;

    public Startup(Logger logger) {
        this.logger = logger;
        this.runtime = Runtime.getInstance();
    }

    public void start() {
        try {
            this.runtime.getConfig().copyConfig("velocity-config.yml", "config.yml");
            this.runtime.getConfig().loadAllConfigs();
            this.runtime.getConfig().loadSecret();
            boolean debugMode = Boolean.parseBoolean(this.runtime.getConfig().getKey("config.yml", "debug"));
            this.logger.setDebug(debugMode);
            this.logger.debug("Debug mode set to: {}", debugMode);
            this.logger.debug("Copying default scripts...", new Object[0]);
            this.runtime.getScriptUtils().copyDefaultScript("velocity-example.yml", "example.yml");
            this.runtime.getScriptUtils().loadAllScripts();
            this.logger.debug("Starting WebSocket server...", new Object[0]);
            this.runtime.getServer().startServer(Integer.parseInt(this.runtime.getConfig().getKey("config.yml", "port")), this.runtime.getConfig().getKey("config.yml", "host"), this.runtime.getConfig().getKey("config.yml", "san"));
            this.logger.debug("Setting up version checker...", new Object[0]);
            VersionChecker.setProjectId("wIuI4ru2");
            this.logger.debug("Checking for updates...", new Object[0]);
            this.checkForUpdates();
            this.logger.debug("Registering internal commands...", new Object[0]);
            this.runtime.getGeneralUtils().registerCommands();
            if (Main.getInstance().proxy.getPluginManager().getPlugin("papiproxybridge").isPresent()) {
                this.logger.info("Hooked into PapiProxyBridge \u2014 PlaceholderAPI placeholders enabled", new Object[0]);
                this.placeholderAPI = true;
            } else {
                this.logger.warn("PapiProxyBridge not found \u2014 using internal placeholder system only", new Object[0]);
                this.placeholderAPI = false;
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize CommandBridge: {}", this.logger.getDebug() != false ? e : e.getMessage());
        }
    }

    public boolean isPlaceholderAPI() {
        return this.placeholderAPI;
    }

    public void stop() {
        try {
            Server server = this.runtime.getServer();
            this.logger.debug("Stopping WebSocket server...", new Object[0]);
            for (String conn : server.getConnectedClients()) {
                this.runtime.getServer().sendTask(server.getWebSocket(conn), "reconnect", "closed");
            }
            this.runtime.getServer().stopServer(0);
        }
        catch (Exception e) {
            this.logger.error("Failed to stop CommandBridge: {}", this.logger.getDebug() != false ? e : e.getMessage());
        }
    }

    private void checkForUpdates() {
        String currentVersion = Main.getVersion();
        this.logger.debug("Current version: {}", currentVersion);
        new Thread(() -> {
            try {
                String latestVersion = VersionChecker.getLatestVersion();
                if (latestVersion == null) {
                    this.logger.warn("Unable to check for updates", new Object[0]);
                    return;
                }
                if (VersionChecker.isNewerVersion(latestVersion, currentVersion)) {
                    this.logger.warn("A new version is available: {}", latestVersion);
                    this.logger.warn("Please download the latest release: {}", VersionChecker.getDownloadUrl());
                } else {
                    this.logger.info("You are running the latest version: {}", currentVersion);
                }
            }
            catch (Exception e) {
                this.logger.error("Error while checking for updates: {}", this.logger.getDebug() != false ? e : e.getMessage());
            }
        }).start();
    }
}

