/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.velocity.helper;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.consti.commandbridge.velocity.Main;
import dev.consti.commandbridge.velocity.core.Runtime;
import dev.consti.commandbridge.velocity.helper.StatusManager;
import dev.consti.foundationlib.logging.Logger;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class FailureChecker
implements Runnable {
    private final Logger logger;
    private final ProxyServer proxy;
    private final Main plugin;
    private final StatusManager statusManager;
    private final CommandSource source;
    private final int maxRetries;
    private final int[] retries;

    public FailureChecker(Logger logger, ProxyServer proxy, Main plugin, StatusManager statusManager, CommandSource source) {
        this.logger = logger;
        this.proxy = proxy;
        this.plugin = plugin;
        this.statusManager = statusManager;
        this.source = source;
        this.maxRetries = Integer.parseInt(Runtime.getInstance().getConfig().getKey("config.yml", "timeout"));
        this.retries = new int[]{0};
    }

    @Override
    public void run() {
        this.retries[0] = this.retries[0] + 1;
        this.logger.debug("Failure check attempt {}/{}", this.retries[0], this.maxRetries);
        try {
            String failedClients = this.statusManager.checkForFailures();
            if (failedClients == null) {
                this.source.sendMessage(Component.text((String)"Everything has reloaded successfully!").color((TextColor)NamedTextColor.GREEN));
                this.logger.info("Scripts reloaded successfully", new Object[0]);
                this.statusManager.clearStatusMap();
            } else if (this.retries[0] >= this.maxRetries) {
                this.source.sendMessage(Component.text((String)("ReloadCommand failed: " + failedClients)).color((TextColor)NamedTextColor.RED));
                this.logger.error("Reload command failed '{}'", failedClients);
                this.statusManager.clearStatusMap();
            } else {
                this.proxy.getScheduler().buildTask((Object)this.plugin, (Runnable)this).delay(1L, TimeUnit.SECONDS).schedule();
            }
        }
        catch (Exception e) {
            this.logger.error("An error occurred during the reload process: {}", this.logger.getDebug() != false ? e : e.getMessage());
            this.source.sendMessage(Component.text((String)"Reload command failed due to an internal error. Check logs for details").color((TextColor)NamedTextColor.RED));
        }
    }
}

