/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.velocity.helper;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.velocitypowered.api.command.CommandSource;
import dev.consti.foundationlib.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class HelpCommand {
    public static LiteralArgumentBuilder<CommandSource> build(Logger logger) {
        return (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"help").executes(context -> HelpCommand.sendHelpMessage((CommandSource)context.getSource(), logger));
    }

    public static int sendHelpMessage(CommandSource source, Logger logger) {
        logger.debug("Sending help message to: {}", source);
        source.sendMessage(Component.text((String)"==== CommandBridge Help ====").color((TextColor)NamedTextColor.GOLD));
        source.sendMessage((Component)Component.text((String)""));
        source.sendMessage(Component.text((String)"Available Commands:").color((TextColor)NamedTextColor.YELLOW));
        source.sendMessage(HelpCommand.formatCommand("help", "Displays this help message", false));
        source.sendMessage(HelpCommand.formatCommand("list", "Lists connected clients", false));
        source.sendMessage(HelpCommand.formatCommand("reload", "Reloads all configs and scripts", false));
        source.sendMessage(HelpCommand.formatCommand("version", "Displays the current version", false));
        source.sendMessage((Component)Component.text((String)""));
        source.sendMessage(Component.text((String)"Debug Commands (Debug mode only):").color((TextColor)NamedTextColor.RED));
        source.sendMessage(HelpCommand.formatCommand("stop", "Stops the cb server", false));
        source.sendMessage(HelpCommand.formatCommand("start", "Starts the cb server", false));
        source.sendMessage((Component)Component.text((String)""));
        source.sendMessage(Component.text((String)"Client Commands (/cbc):").color((TextColor)NamedTextColor.AQUA));
        source.sendMessage(HelpCommand.formatCommand("reconnect", "Reconnects the current client", true));
        source.sendMessage((Component)Component.text((String)""));
        source.sendMessage(Component.text((String)"Website: ").append(((TextComponent)((TextComponent)Component.text((String)"https://cb.objz.dev").color((TextColor)NamedTextColor.LIGHT_PURPLE)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.openUrl((String)"https://cb.objz.dev"))));
        source.sendMessage((Component)Component.text((String)""));
        source.sendMessage(Component.text((String)"============================").color((TextColor)NamedTextColor.GOLD));
        return 1;
    }

    private static Component formatCommand(String command, String description, boolean client) {
        String alias = client ? "/cbc " : "/cb ";
        return ((TextComponent)Component.text((String)"  - ").append(Component.text((String)(alias + command)).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)(" - " + description)).color((TextColor)NamedTextColor.WHITE));
    }
}

