/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.velocity.helper;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.consti.commandbridge.velocity.Main;
import dev.consti.commandbridge.velocity.core.Runtime;
import dev.consti.commandbridge.velocity.helper.HelpCommand;
import dev.consti.commandbridge.velocity.helper.command.ListCommand;
import dev.consti.commandbridge.velocity.helper.command.ReloadCommand;
import dev.consti.commandbridge.velocity.helper.command.StartCommand;
import dev.consti.commandbridge.velocity.helper.command.StopCommand;
import dev.consti.commandbridge.velocity.helper.command.VersionCommand;
import dev.consti.foundationlib.logging.Logger;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class InternalRegistrar {
    private final Logger logger;
    private final ProxyServer proxy;
    private final Main plugin;
    private final Set<String> connectedClients;

    public InternalRegistrar(Logger logger, ProxyServer proxy, Main plugin, Set<String> connectedClients) {
        this.logger = logger;
        this.proxy = proxy;
        this.plugin = plugin;
        this.connectedClients = connectedClients;
    }

    public void registerCommands() {
        this.logger.info("Registering commands for CommandBridge...", new Object[0]);
        try {
            LiteralArgumentBuilder commandBridgeBuilder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"commandbridge").executes(context -> {
                if (((CommandSource)context.getSource()).hasPermission("commandbridge.admin")) {
                    return HelpCommand.sendHelpMessage((CommandSource)context.getSource(), this.logger);
                }
                ((CommandSource)context.getSource()).sendMessage((Component)Component.text((String)"You do not have permission to use this command", (TextColor)NamedTextColor.RED));
                return 0;
            });
            commandBridgeBuilder.then(ReloadCommand.build(Runtime.getInstance().getGeneralUtils(), this.logger));
            commandBridgeBuilder.then(VersionCommand.build(this.logger));
            commandBridgeBuilder.then(HelpCommand.build(this.logger));
            commandBridgeBuilder.then(ListCommand.build(this.connectedClients, this.logger));
            if (this.logger.getDebug().booleanValue()) {
                commandBridgeBuilder.then(StopCommand.build(this.logger));
                commandBridgeBuilder.then(StartCommand.build(this.logger));
            }
            LiteralCommandNode commandBridgeNode = commandBridgeBuilder.build();
            Runtime.getInstance().getGeneralUtils().setMeta(this.proxy.getCommandManager().metaBuilder("commandbridge").aliases(new String[]{"cb"}).plugin((Object)this.plugin).build());
            BrigadierCommand brigadierCommand = new BrigadierCommand(commandBridgeNode);
            this.proxy.getCommandManager().register(Runtime.getInstance().getGeneralUtils().getMeta(), (Command)brigadierCommand);
            this.logger.info("CommandBridge commands registered successfully", new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Failed to register CommandBridge commands: {}", this.logger.getDebug() != false ? e : e.getMessage());
        }
    }
}

