/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.velocity.helper;

import dev.consti.commandbridge.velocity.core.Runtime;
import dev.consti.foundationlib.logging.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StatusManager {
    private final Logger logger;
    private final Map<String, String> statusMap = new HashMap<String, String>();
    private final Set<String> connectedClients = Runtime.getInstance().getServer().getConnectedClients();

    public StatusManager(Logger logger) {
        this.logger = logger;
    }

    public void addClientToStatus(String clientId, String status) {
        this.statusMap.put(clientId, status);
        this.logger.debug("Updated statusMap: {}", this.statusMap);
    }

    public void clearStatusMap() {
        this.statusMap.clear();
    }

    public String checkForFailures() {
        this.logger.debug("Checking for failures...", new Object[0]);
        List<String> missingClients = this.connectedClients.stream().filter(client -> !this.statusMap.containsKey(client)).toList();
        if (!missingClients.isEmpty()) {
            String missingClientString = String.join((CharSequence)", ", missingClients);
            this.logger.warn("Waiting for responses from clients: {}", missingClientString);
            return "Missing responses from: " + missingClientString;
        }
        String failedClients = this.statusMap.entrySet().stream().filter(entry -> !"success".equals(entry.getValue())).map(Map.Entry::getKey).reduce((a, b) -> a + ", " + b).orElse(null);
        if (failedClients != null) {
            this.logger.error("Failure detected on clients: {}", failedClients);
            return "Failure detected on: " + failedClients;
        }
        this.logger.debug("No failures detected. All clients are operational", new Object[0]);
        return null;
    }
}

