/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.velocity.helper.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.velocitypowered.api.command.CommandSource;
import dev.consti.commandbridge.velocity.Main;
import dev.consti.foundationlib.logging.Logger;
import dev.consti.foundationlib.utils.VersionChecker;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class VersionCommand {
    public static LiteralArgumentBuilder<CommandSource> build(Logger logger) {
        return (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"version").executes(context -> {
            CommandSource source = (CommandSource)context.getSource();
            if (!source.hasPermission("commandbridge.admin")) {
                source.sendMessage((Component)Component.text((String)"You do not have permission to check the version", (TextColor)NamedTextColor.RED));
                return 0;
            }
            String currentVersion = Main.getVersion();
            source.sendMessage(Component.text((String)"Checking for updates...").color((TextColor)NamedTextColor.YELLOW));
            logger.debug("VersionCommand executed by: {}", source);
            new Thread(() -> {
                String latestVersion = VersionChecker.getLatestVersion();
                if (latestVersion == null) {
                    source.sendMessage(Component.text((String)"Unable to check for updates").color((TextColor)NamedTextColor.RED));
                    logger.warn("Failed to retrieve latest version for update check", new Object[0]);
                    return;
                }
                logger.debug("Current version: {}, Latest version: {}", currentVersion, latestVersion);
                if (VersionChecker.isNewerVersion(latestVersion, currentVersion)) {
                    source.sendMessage(Component.text((String)("A new version is available: " + latestVersion)).color((TextColor)NamedTextColor.RED));
                    source.sendMessage(Component.text((String)"Please download the latest release: ").append(((TextComponent)((TextComponent)Component.text((String)"here").color((TextColor)NamedTextColor.BLUE)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.openUrl((String)VersionChecker.getDownloadUrl()))));
                    logger.warn("A newer version is available: {}", latestVersion);
                } else {
                    source.sendMessage(Component.text((String)("You are running the latest version: " + currentVersion)).color((TextColor)NamedTextColor.GREEN));
                }
            }).start();
            return 1;
        });
    }
}

