/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.velocity.util;

import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.consti.commandbridge.velocity.Main;
import dev.consti.commandbridge.velocity.core.Runtime;
import dev.consti.commandbridge.velocity.helper.FailureChecker;
import dev.consti.commandbridge.velocity.helper.InternalRegistrar;
import dev.consti.commandbridge.velocity.helper.StatusManager;
import dev.consti.commandbridge.velocity.util.ProxyUtils;
import dev.consti.foundationlib.logging.Logger;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class GeneralUtils {
    private final Logger logger;
    private final ProxyServer proxy;
    private final Main plugin;
    private final StatusManager statusManager;
    private final Set<String> connectedClients;
    private CommandMeta meta;

    public GeneralUtils(Logger logger) {
        this.logger = logger;
        this.proxy = ProxyUtils.getProxyServer();
        this.plugin = Main.getInstance();
        this.connectedClients = Runtime.getInstance().getServer().getConnectedClients();
        this.statusManager = new StatusManager(logger);
    }

    public void addClientToStatus(String clientId, String status) {
        this.statusManager.addClientToStatus(clientId, status);
    }

    public void startFailureCheck(CommandSource source) {
        this.statusManager.clearStatusMap();
        FailureChecker checkTask = new FailureChecker(this.logger, this.proxy, this.plugin, this.statusManager, source);
        try {
            this.proxy.getScheduler().buildTask((Object)this.plugin, (Runnable)checkTask).delay(1L, TimeUnit.SECONDS).schedule();
        }
        catch (Exception e) {
            this.logger.error("Failed to schedule the reload check task: {}", this.logger.getDebug() != false ? e : e.getMessage());
            source.sendMessage(Component.text((String)"Reload command failed: Unable to start the failure check").color((TextColor)NamedTextColor.RED));
        }
    }

    public void registerCommands() {
        InternalRegistrar registrar = new InternalRegistrar(this.logger, this.proxy, this.plugin, this.connectedClients);
        registrar.registerCommands();
    }

    public CommandMeta getMeta() {
        return this.meta;
    }

    public void setMeta(CommandMeta commandMeta) {
        this.meta = commandMeta;
    }

    public void unregisterCommands() {
        this.proxy.getCommandManager().unregister(this.meta);
    }
}

