/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.commandbridge.velocity.websocket;

import dev.consti.foundationlib.logging.Logger;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.NotSslRecordException;
import javax.net.ssl.SSLHandshakeException;

@ChannelHandler.Sharable
public class HttpServer
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private Logger logger;

    public HttpServer(Logger logger) {
        this.logger = logger;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
        String uri = msg.uri();
        this.logger.debug("Incoming HTTP request to: {}", uri);
        if ("/ping".equalsIgnoreCase(uri)) {
            this.sendTextResponse(ctx, HttpResponseStatus.OK, "pong");
        } else if ("websocket".equalsIgnoreCase(msg.headers().get(HttpHeaderNames.UPGRADE))) {
            ctx.fireChannelRead(msg.retain());
        } else {
            this.sendTextResponse(ctx, HttpResponseStatus.NOT_FOUND, "Not Found");
        }
    }

    private void sendTextResponse(ChannelHandlerContext ctx, HttpResponseStatus status, String content) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, ctx.alloc().buffer().writeBytes(content.getBytes()));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        ctx.writeAndFlush(response);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof NotSslRecordException || cause instanceof SSLHandshakeException) {
            if (this.logger.getDebug().booleanValue()) {
                this.logger.debug("SSL handshake or protocol error", cause);
            } else {
                this.logger.warn("Received invalid or unsupported SSL/TLS connection (enable debug for full trace)", new Object[0]);
            }
        } else if (this.logger.getDebug().booleanValue()) {
            this.logger.error("Unexpected error in HttpServer handler", cause);
        } else {
            this.logger.error("Unexpected error in HttpServer handler: {}", cause.getMessage());
        }
        ctx.close();
    }
}

