/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.foundationlib.json;

import org.json.JSONArray;
import org.json.JSONObject;

public class MessageParser {
    private final JSONObject jsonObject;

    public MessageParser(String jsonString) {
        this.jsonObject = new JSONObject(jsonString);
    }

    public String getType() {
        return this.jsonObject.optString("type", null);
    }

    public String getStatus() {
        return this.jsonObject.optString("status", null);
    }

    public String getTimestamp() {
        return this.jsonObject.optString("timestamp", null);
    }

    public JSONObject getBody() {
        return this.jsonObject.optJSONObject("body");
    }

    public Object getBodyValue(String key) {
        JSONObject body = this.getBody();
        return body != null ? body.opt(key) : null;
    }

    public String getBodyValueAsString(String key) {
        return (String)this.getBodyValue(key);
    }

    public int getBodyValueAsInt(String key) {
        Object value = this.getBodyValue(key);
        return value instanceof Integer ? (Integer)value : 0;
    }

    public boolean getBodyValueAsBoolean(String key) {
        Object value = this.getBodyValue(key);
        return value instanceof Boolean && (Boolean)value != false;
    }

    public JSONArray getBodyValueAsArray(String key) {
        Object value = this.getBodyValue(key);
        return value instanceof JSONArray ? (JSONArray)value : null;
    }

    public JSONObject getBodyValueAsObject(String key) {
        Object value = this.getBodyValue(key);
        return value instanceof JSONObject ? (JSONObject)value : null;
    }

    public boolean containsBodyKey(String key) {
        JSONObject body = this.getBody();
        return body != null && body.has(key);
    }
}

