/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.foundationlib.utils;

import dev.consti.foundationlib.logging.Logger;
import dev.consti.foundationlib.utils.TLSUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ConfigManager {
    private final Map<String, Map<String, Object>> configData = new HashMap<String, Map<String, Object>>();
    private String secret;
    private final Yaml yaml;
    private final Logger logger;
    private final String configDirectory;
    private final String secretFileName;

    public ConfigManager(Logger logger, String pluginName) {
        this(logger, pluginName, "secret.key");
    }

    public ConfigManager(Logger logger, String pluginName, String secretFileName) {
        this.logger = logger;
        this.configDirectory = "plugins" + File.separator + (pluginName != null ? pluginName : "FoundationLib");
        this.secretFileName = secretFileName;
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml(options);
    }

    public void loadAllConfigs() {
        File configDir = new File(this.configDirectory);
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new RuntimeException("Failed to create config directory: " + this.configDirectory);
        }
        try {
            Files.list(configDir.toPath()).filter(path -> path.toString().endsWith(".yml")).forEach(this::loadConfigFile);
            this.logger.debug("All configuration files have been loaded from directory: {}", this.configDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load configuration files: " + e.getMessage(), e);
        }
    }

    public void reload() {
        this.configData.clear();
        this.loadAllConfigs();
        this.logger.info("All configurations have been successfully reloaded", new Object[0]);
    }

    private void loadConfigFile(Path path) {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            HashMap fileconfigData = (HashMap)this.yaml.load(inputStream);
            if (fileconfigData == null) {
                fileconfigData = new HashMap();
            }
            this.configData.put(path.getFileName().toString(), fileconfigData);
            this.logger.debug("Config file loaded successfully: {}", path.getFileName().toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config file: " + e.getMessage(), e);
        }
    }

    public void loadSecret() {
        File secretFile = new File(this.configDirectory, this.secretFileName);
        if (!secretFile.exists()) {
            this.generateSecret();
        }
        try (InputStream inputStream = Files.newInputStream(secretFile.toPath(), new OpenOption[0]);){
            this.secret = new String(inputStream.readAllBytes());
            this.logger.debug("Secret file loaded successfully from path: {}", secretFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load secret file: " + e.getMessage(), e);
        }
    }

    public String getKey(String fileName, String key) {
        Map<String, Object> fileConfigData = this.configData.get(fileName);
        if (fileConfigData != null && fileConfigData.containsKey(key)) {
            this.logger.debug("Retrieved key '{}' from config: {}", key, fileName);
            return fileConfigData.get(key).toString();
        }
        throw new RuntimeException("Key '" + key + "' not found in config: " + fileName);
    }

    public String getSecret() {
        if (this.secret != null) {
            this.logger.debug("Retrieved secret", new Object[0]);
            return this.secret;
        }
        this.logger.error("Secret not found", new Object[0]);
        return null;
    }

    protected void generateSecret() {
        File configDir = new File(this.configDirectory);
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new RuntimeException("Failed to create config directory: " + this.configDirectory);
        }
        File secretFile = new File(configDir, this.secretFileName);
        if (secretFile.exists()) {
            this.logger.debug("Secret file already exists, skipping copy", new Object[0]);
            return;
        }
        try (OutputStream out = Files.newOutputStream(secretFile.toPath(), new OpenOption[0]);){
            String secret = TLSUtils.generateSecret();
            out.write(secret.getBytes());
            this.logger.info("Secret file generated successfully at: {}", secretFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate secret file: " + e.getMessage(), e);
        }
    }

    public void copyConfig(String resourceName, String targetFileName) {
        File configDir = new File(this.configDirectory);
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new RuntimeException("Failed to create config directory: " + this.configDirectory);
        }
        File configFile = new File(configDir, targetFileName);
        if (configFile.exists()) {
            this.logger.debug("Config file '{}' already exists, skipping copy", configFile.getAbsolutePath());
            return;
        }
        try (InputStream in = this.getClass().getResourceAsStream("/" + resourceName);
             OutputStream out = Files.newOutputStream(configFile.toPath(), new OpenOption[0]);){
            int len;
            if (in == null) {
                throw new RuntimeException("Resource '" + resourceName + "' not found in the plugin JAR");
            }
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            this.logger.info("Default config '{}' copied to: {}", resourceName, configFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy default config file " + resourceName + ": " + e.getMessage(), e);
        }
    }
}

