/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.foundationlib.utils;

import dev.consti.foundationlib.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public abstract class ScriptManager {
    private final Map<String, ScriptConfig> scripts = new HashMap<String, ScriptConfig>();
    private final Yaml yaml;
    private final Logger logger;
    private final String scriptsDirectory;

    public ScriptManager(Logger logger, String pluginName) {
        this.logger = logger;
        this.scriptsDirectory = "plugins" + File.separator + pluginName + File.separator + "scripts";
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml(options);
    }

    public void loadAllScripts() {
        File dir = new File(this.scriptsDirectory);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Failed to create scripts directory: " + this.scriptsDirectory);
        }
        try {
            Files.list(dir.toPath()).filter(path -> path.toString().endsWith(".yml")).forEach(this::loadScriptFile);
            this.logger.debug("All script files have been loaded from directory: {}", this.scriptsDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load scripts: " + e.getMessage(), e);
        }
    }

    public void reload() {
        this.scripts.clear();
        this.loadAllScripts();
        this.logger.info("All scripts have been successfully reloaded", new Object[0]);
    }

    private void loadScriptFile(Path path) {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            HashMap<String, Object> fileData = (HashMap<String, Object>)this.yaml.load(inputStream);
            if (fileData == null) {
                fileData = new HashMap<String, Object>();
            }
            ScriptConfig scriptConfig = new ScriptConfig(fileData);
            this.scripts.put(path.getFileName().toString(), scriptConfig);
            this.logger.debug("Script file loaded successfully: {}", path.getFileName().toString());
            this.onFileProcessed(path.getFileName().toString(), scriptConfig);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load script file '" + String.valueOf(path.getFileName()) + "': " + e.getMessage(), e);
        }
    }

    public ScriptConfig getScriptConfig(String fileName) {
        this.logger.debug("Retrieved config", new Object[0]);
        return this.scripts.get(fileName);
    }

    public void copyDefaultScript(String resourceName, String targetFileName) {
        File scriptDir = new File(this.scriptsDirectory);
        if (!scriptDir.exists() && !scriptDir.mkdirs()) {
            throw new RuntimeException("Failed to create script directory: " + this.scriptsDirectory);
        }
        File scriptFile = new File(scriptDir, targetFileName);
        if (scriptFile.exists()) {
            this.logger.debug("Script file '{}' already exists, skipping copy", scriptFile.getAbsolutePath());
            return;
        }
        try (InputStream in = this.getClass().getResourceAsStream("/" + resourceName);
             OutputStream out = Files.newOutputStream(scriptFile.toPath(), new OpenOption[0]);){
            int len;
            if (in == null) {
                throw new RuntimeException("Resource '" + resourceName + "' not found in the plugin JAR");
            }
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            this.logger.info("Default script '{}' copied to: {}", resourceName, scriptFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy default script file " + resourceName + ": " + e.getMessage(), e);
        }
    }

    public abstract void onFileProcessed(String var1, ScriptConfig var2);

    public static class ScriptConfig {
        private final String name;
        private final boolean enabled;
        private final boolean ignorePermissionCheck;
        private final boolean hidePermissionWarning;
        private final List<Command> commands;

        public ScriptConfig(Map<String, Object> data) {
            this.name = (String)data.getOrDefault("name", "Unnamed Command");
            this.enabled = (Boolean)data.getOrDefault("enabled", false);
            this.ignorePermissionCheck = (Boolean)data.getOrDefault("ignore-permission-check", false);
            this.hidePermissionWarning = (Boolean)data.getOrDefault("hide-permission-warning", false);
            this.commands = new ArrayList<Command>();
            Object commandsObject = data.get("commands");
            if (commandsObject instanceof List) {
                List commandsList = (List)commandsObject;
                for (Object commandData : commandsList) {
                    if (!(commandData instanceof Map)) continue;
                    this.commands.add(new Command((Map)commandData));
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean shouldIgnorePermissionCheck() {
            return this.ignorePermissionCheck;
        }

        public boolean shouldHidePermissionWarning() {
            return this.hidePermissionWarning;
        }

        public List<Command> getCommands() {
            return this.commands;
        }
    }

    public static class Command {
        private final String command;
        private final int delay;
        private final List<String> targetClientIds;
        private final String targetExecutor;
        private final boolean waitUntilPlayerIsOnline;
        private final boolean checkIfExecutorIsPlayer;
        private final boolean checkIfExecutorIsOnServer;

        public Command(Map<String, Object> data) {
            this.command = (String)data.get("command");
            this.delay = (Integer)data.getOrDefault("delay", 0);
            this.targetClientIds = data.getOrDefault("target-client-ids", new ArrayList());
            this.targetExecutor = (String)data.getOrDefault("target-executor", "console");
            this.waitUntilPlayerIsOnline = (Boolean)data.getOrDefault("wait-until-player-is-online", false);
            this.checkIfExecutorIsPlayer = (Boolean)data.getOrDefault("check-if-executor-is-player", true);
            this.checkIfExecutorIsOnServer = (Boolean)data.getOrDefault("check-if-executor-is-on-server", true);
        }

        public String getCommand() {
            return this.command;
        }

        public int getDelay() {
            return this.delay;
        }

        public List<String> getTargetClientIds() {
            return this.targetClientIds;
        }

        public String getTargetExecutor() {
            return this.targetExecutor;
        }

        public boolean shouldWaitUntilPlayerIsOnline() {
            return this.waitUntilPlayerIsOnline;
        }

        public boolean isCheckIfExecutorIsPlayer() {
            return this.checkIfExecutorIsPlayer;
        }

        public boolean isCheckIfExecutorIsOnServer() {
            return this.checkIfExecutorIsOnServer;
        }
    }
}

