/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.foundationlib.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringParser {
    private final Map<String, String> placeholders = new HashMap<String, String>();

    public void addPlaceholder(String placeholder, String value) {
        this.placeholders.put(placeholder, value);
    }

    public void removePlaceholder(String placeholder) {
        this.placeholders.remove(placeholder);
    }

    public String parsePlaceholders(String command, String[] args) {
        if (!this.placeholders.isEmpty()) {
            for (Map.Entry<String, String> entry : this.placeholders.entrySet()) {
                String placeholder = entry.getKey();
                String value = entry.getValue();
                command = command.replace(placeholder, value != null ? value : "");
            }
        }
        command = command.replace("%args%", args != null ? String.join((CharSequence)" ", args) : "");
        if (args != null) {
            command = this.replaceArgPlaceholders(command, args);
        }
        return command;
    }

    public void clearPlaceholders() {
        this.placeholders.clear();
    }

    private String replaceArgPlaceholders(String command, String[] args) {
        Pattern pattern = Pattern.compile("%arg\\[(\\d+)]%");
        Matcher matcher = pattern.matcher(command);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            int index = Integer.parseInt(matcher.group(1));
            String replacement = index >= 0 && index < args.length ? args[index] : "";
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static StringParser create() {
        return new StringParser();
    }
}

