/*
 * Decompiled with CFR 0.152.
 */
package dev.consti.foundationlib.utils;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class VersionChecker {
    private static String projectId;
    private static String MODRINTH_API_URL;
    private static final Pattern VERSION_PATTERN;

    public static void setProjectId(String id) {
        projectId = id;
        MODRINTH_API_URL = "https://api.modrinth.com/v2/project/" + projectId + "/version";
    }

    public static String getLatestVersion() {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(MODRINTH_API_URL)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String responseBody = response.body();
            JSONArray versions = new JSONArray(responseBody);
            if (!versions.isEmpty()) {
                JSONObject latestVersion = versions.getJSONObject(0);
                return latestVersion.getString("version_number");
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isNewerVersion(String latestVersion, String currentVersion) {
        String[] latestParts = latestVersion.split("\\.");
        String[] currentParts = currentVersion.split("\\.");
        int length = Math.max(latestParts.length, currentParts.length);
        for (int i = 0; i < length; ++i) {
            int currentPart;
            int latestPart = i < latestParts.length ? VersionChecker.parseVersionPart(latestParts[i]) : 0;
            int n = currentPart = i < currentParts.length ? VersionChecker.parseVersionPart(currentParts[i]) : 0;
            if (latestPart > currentPart) {
                return true;
            }
            if (latestPart >= currentPart) continue;
            return false;
        }
        return false;
    }

    private static int parseVersionPart(String versionPart) {
        Matcher matcher = VERSION_PATTERN.matcher(versionPart);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group());
        }
        return 0;
    }

    public static String getDownloadUrl() {
        return "https://modrinth.com/plugin/" + projectId + "/versions";
    }

    public static boolean checkBukkitVersion(String bukkitVersion, String currentVersion) {
        String[] bukkitParts = bukkitVersion.split("\\.");
        String[] currentParts = currentVersion.split("\\.");
        for (int i = 0; i < Math.min(bukkitParts.length, currentParts.length); ++i) {
            if (bukkitParts[i].equals(currentParts[i])) continue;
            return false;
        }
        return bukkitParts.length == currentParts.length;
    }

    static {
        VERSION_PATTERN = Pattern.compile("\\d+");
    }
}

