/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Converters;
import io.jsonwebtoken.impl.lang.DefaultParameterBuilder;
import io.jsonwebtoken.impl.lang.IdRegistry;
import io.jsonwebtoken.impl.lang.JwtDateConverter;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.ParameterBuilder;
import io.jsonwebtoken.impl.lang.ParameterReadable;
import io.jsonwebtoken.lang.Arrays;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Registry;
import java.math.BigInteger;
import java.net.URI;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class Parameters {
    private Parameters() {
    }

    public static Parameter<String> string(String id, String name) {
        return (Parameter)Parameters.builder(String.class).setId(id).setName(name).build();
    }

    public static Parameter<Date> rfcDate(String id, String name) {
        return (Parameter)Parameters.builder(Date.class).setConverter(JwtDateConverter.INSTANCE).setId(id).setName(name).build();
    }

    public static Parameter<List<X509Certificate>> x509Chain(String id, String name) {
        return (Parameter)Parameters.builder(X509Certificate.class).setConverter(Converters.X509_CERTIFICATE).list().setId(id).setName(name).build();
    }

    public static <T> ParameterBuilder<T> builder(Class<T> type) {
        return new DefaultParameterBuilder<T>(type);
    }

    public static Parameter<Set<String>> stringSet(String id, String name) {
        return (Parameter)Parameters.builder(String.class).set().setId(id).setName(name).build();
    }

    public static Parameter<URI> uri(String id, String name) {
        return (Parameter)Parameters.builder(URI.class).setConverter(Converters.URI).setId(id).setName(name).build();
    }

    public static ParameterBuilder<byte[]> bytes(String id, String name) {
        return Parameters.builder(byte[].class).setConverter(Converters.BASE64URL_BYTES).setId(id).setName(name);
    }

    public static ParameterBuilder<BigInteger> bigInt(String id, String name) {
        return Parameters.builder(BigInteger.class).setConverter(Converters.BIGINT).setId(id).setName(name);
    }

    public static Parameter<BigInteger> secretBigInt(String id, String name) {
        return (Parameter)Parameters.bigInt(id, name).setSecret(true).build();
    }

    public static Registry<String, Parameter<?>> registry(Parameter<?> ... params) {
        return Parameters.registry(Arrays.asList(params));
    }

    public static Registry<String, Parameter<?>> registry(Collection<Parameter<?>> params) {
        return new IdRegistry("Parameter", params, true);
    }

    public static Registry<String, Parameter<?>> registry(Registry<String, Parameter<?>> parent, Parameter<?> ... params) {
        LinkedHashSet<Object> set = new LinkedHashSet<Object>(parent.size() + params.length);
        set.addAll(parent.values());
        set.addAll(Arrays.asList(params));
        return new IdRegistry("Parameter", set, true);
    }

    public static Registry<String, ? extends Parameter<?>> replace(Registry<String, ? extends Parameter<?>> registry, Parameter<?> param) {
        Assert.notEmpty(registry, "Registry cannot be null or empty.");
        Assert.notNull(param, "Parameter cannot be null.");
        String id = Assert.hasText(param.getId(), "Parameter id cannot be null or empty.");
        LinkedHashMap newParams = new LinkedHashMap(registry);
        newParams.remove(id);
        newParams.put(id, param);
        return Parameters.registry(newParams.values());
    }

    private static byte[] bytes(BigInteger i) {
        return i != null ? i.toByteArray() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean bytesEquals(BigInteger a2, BigInteger b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        byte[] aBytes = Parameters.bytes(a2);
        byte[] bBytes = Parameters.bytes(b2);
        try {
            boolean bl = MessageDigest.isEqual(aBytes, bBytes);
            return bl;
        }
        finally {
            Bytes.clear(aBytes);
            Bytes.clear(bBytes);
        }
    }

    private static <T> boolean equals(T a2, T b2, Parameter<T> param) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        if (param.isSecret()) {
            if (a2 instanceof byte[]) {
                return b2 instanceof byte[] && MessageDigest.isEqual((byte[])a2, (byte[])b2);
            }
            if (a2 instanceof BigInteger) {
                return b2 instanceof BigInteger && Parameters.bytesEquals((BigInteger)a2, (BigInteger)b2);
            }
        }
        return Objects.nullSafeEquals(a2, b2);
    }

    public static <T> boolean equals(ParameterReadable a2, Object o, Parameter<T> param) {
        if (a2 == o) {
            return true;
        }
        if (a2 == null || !(o instanceof ParameterReadable)) {
            return false;
        }
        ParameterReadable b2 = (ParameterReadable)o;
        return Parameters.equals(a2.get(param), b2.get(param), param);
    }
}

