/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.DefaultNestedCollection;
import io.jsonwebtoken.impl.lang.DelegatingMapMutator;
import io.jsonwebtoken.impl.lang.IdRegistry;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.Parameters;
import io.jsonwebtoken.impl.security.AbstractJwk;
import io.jsonwebtoken.impl.security.DefaultMacAlgorithm;
import io.jsonwebtoken.impl.security.DispatchingJwkFactory;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.JwkFactory;
import io.jsonwebtoken.impl.security.KeyOperationConverter;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.NestedCollection;
import io.jsonwebtoken.security.HashAlgorithm;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.JwkBuilder;
import io.jsonwebtoken.security.Jwks;
import io.jsonwebtoken.security.KeyOperation;
import io.jsonwebtoken.security.KeyOperationPolicy;
import io.jsonwebtoken.security.MalformedKeyException;
import io.jsonwebtoken.security.SecretJwk;
import io.jsonwebtoken.security.SecretJwkBuilder;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collection;
import javax.crypto.SecretKey;

abstract class AbstractJwkBuilder<K extends Key, J extends Jwk<K>, T extends JwkBuilder<K, J, T>>
extends DelegatingMapMutator<String, Object, JwkContext<K>, T>
implements JwkBuilder<K, J, T> {
    protected final JwkFactory<K, J> jwkFactory;
    static final KeyOperationPolicy DEFAULT_OPERATION_POLICY = (KeyOperationPolicy)Jwks.OP.policy().build();
    protected KeyOperationPolicy opsPolicy = DEFAULT_OPERATION_POLICY;

    protected AbstractJwkBuilder(JwkContext<K> jwkContext) {
        this(jwkContext, DispatchingJwkFactory.DEFAULT_INSTANCE);
    }

    protected AbstractJwkBuilder(JwkContext<K> context, JwkFactory<K, J> factory) {
        super(context);
        this.jwkFactory = Assert.notNull(factory, "JwkFactory cannot be null.");
    }

    protected <A extends Key> JwkContext<A> newContext(A key) {
        return this.jwkFactory.newContext((JwkContext)this.DELEGATE, key);
    }

    @Override
    public T provider(Provider provider) {
        ((JwkContext)this.DELEGATE).setProvider(provider);
        return (T)((JwkBuilder)this.self());
    }

    @Override
    public T random(SecureRandom random) {
        ((JwkContext)this.DELEGATE).setRandom(random);
        return (T)((JwkBuilder)this.self());
    }

    @Override
    public T algorithm(String alg) {
        Assert.hasText(alg, "Algorithm cannot be null or empty.");
        ((JwkContext)this.DELEGATE).setAlgorithm(alg);
        return (T)((JwkBuilder)this.self());
    }

    @Override
    public T id(String id) {
        Assert.hasText(id, "Id cannot be null or empty.");
        ((JwkContext)this.DELEGATE).setIdThumbprintAlgorithm(null);
        ((JwkContext)this.DELEGATE).setId(id);
        return (T)((JwkBuilder)this.self());
    }

    @Override
    public T idFromThumbprint() {
        return this.idFromThumbprint(Jwks.HASH.SHA256);
    }

    @Override
    public T idFromThumbprint(HashAlgorithm alg) {
        Assert.notNull(alg, "Thumbprint HashAlgorithm cannot be null.");
        Assert.notNull(alg.getId(), "Thumbprint HashAlgorithm ID cannot be null.");
        ((JwkContext)this.DELEGATE).setId(null);
        ((JwkContext)this.DELEGATE).setIdThumbprintAlgorithm(alg);
        return (T)((JwkBuilder)this.self());
    }

    @Override
    public NestedCollection<KeyOperation, T> operations() {
        return new DefaultNestedCollection<KeyOperation, T>((JwkBuilder)this.self(), ((JwkContext)this.DELEGATE).getOperations()){

            @Override
            protected void changed() {
                Collection c2 = this.getCollection();
                AbstractJwkBuilder.this.opsPolicy.validate(c2);
                ((JwkContext)AbstractJwkBuilder.this.DELEGATE).setOperations(c2);
            }
        };
    }

    @Override
    public T operationPolicy(KeyOperationPolicy policy) throws IllegalArgumentException {
        Assert.notNull(policy, "Policy cannot be null.");
        Collection<KeyOperation> ops = policy.getOperations();
        Assert.notEmpty(ops, "Policy operations cannot be null or empty.");
        this.opsPolicy = policy;
        IdRegistry<KeyOperation> registry = new IdRegistry<KeyOperation>("JSON Web Key Operation", ops);
        Parameter param = (Parameter)Parameters.builder(KeyOperation.class).setConverter(new KeyOperationConverter(registry)).set().setId(AbstractJwk.KEY_OPS.getId()).setName(AbstractJwk.KEY_OPS.getName()).build();
        this.setDelegate(((JwkContext)this.DELEGATE).parameter(param));
        return (T)((JwkBuilder)this.self());
    }

    @Override
    public J build() {
        Assert.stateNotNull(this.DELEGATE, "JwkContext should always be non-null");
        Object key = ((JwkContext)this.DELEGATE).getKey();
        if (key == null && this.isEmpty()) {
            String msg = "A " + Key.class.getName() + " or one or more name/value pairs must be provided to create a JWK.";
            throw new IllegalStateException(msg);
        }
        try {
            this.opsPolicy.validate((Collection<? extends KeyOperation>)((JwkContext)this.DELEGATE).get(AbstractJwk.KEY_OPS));
            return this.jwkFactory.createJwk((JwkContext)this.DELEGATE);
        }
        catch (IllegalArgumentException iae) {
            String msg = "Unable to create JWK: " + iae.getMessage();
            throw new MalformedKeyException(msg, iae);
        }
    }

    static class DefaultSecretJwkBuilder
    extends AbstractJwkBuilder<SecretKey, SecretJwk, SecretJwkBuilder>
    implements SecretJwkBuilder {
        public DefaultSecretJwkBuilder(JwkContext<SecretKey> ctx) {
            super(ctx);
            Key key = Assert.notNull(ctx.getKey(), "SecretKey cannot be null.");
            DefaultMacAlgorithm mac = DefaultMacAlgorithm.findByKey(key);
            if (mac != null) {
                this.algorithm(mac.getId());
            }
        }
    }
}

